<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo ="CARREIRO";
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>?v=1" >
    
    <link rel="stylesheet" href="<?php echo e(asset('animate-css/animate.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('aos-master/aos.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('owl-carousel/assets/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('owl-carousel/assets/owl.theme.default.min.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. <?php echo e($titulo); ?>® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/fondos/intro_angelita-2-colchones-carreiro.jpg')); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. <?php echo e($titulo); ?>® ¡Por tradición!" />

	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css?v=1')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/index.css?v=31')); ?>">

	<link rel="stylesheet" href="<?php echo e(asset('css/acordeon.css?v=13')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/unleash.3.css')); ?>">
	<?php
		use Jenssegers\Agent\Agent;
		$agent = new Agent();
	?>
	<?php if($agent->isIE()): ?>
		<link rel="stylesheet" href="<?php echo e(asset('css/ie.css')); ?>">
	<?php endif; ?>

	<style>
		#btn-cerrar-video {
			background-color: rgba(0,0,0,.41);
			border: 1px solid white;
			cursor:pointer;
			width: 255px;
			height: 65px;
			color: white;
			font-size: 20px;
		}
		#boton-con-manita {
			position: absolute;
			left: 50%;
			margin-left: calc(-255px / 2);
			bottom: 150px;
			display: none;
		}
		#boton-con-manita img {
			position: absolute;
			left: -25px;
			bottom: -25px;
			cursor: pointer;
		}
		#btn-saltar {
			right: 50px;
			bottom: 50px;
			border-radius: 30px;
		}
	</style>
</head>
<body>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php if(!((isset($_GET['m'])) || (isset($_GET['contactanos'])))): ?>
		<div class="index-video-wrapper">
			<video autoplay muted id="index-video">
                <source src="<?php echo e(asset('video/fondo_web.mp4?v=1')); ?>" type="video/mp4">
				
			</video>
			<div id="boton-con-manita">
				<button id="btn-cerrar-video" class="raleway_regular">ADÉNTRATE AL MUNDO<br>DEL <span class="naranja">DESCANSO</button>
				<img src="<?php echo e(asset('img/iconos/manita-colchones-carreiro.svg')); ?>" alt="Donde compro mi colchon" style="width:auto;height:50px;" class="animated infinite pulse">
			</div>
			<button class="position-absolute btn btn-outline-light" id="btn-saltar" onclick="saltar_intro()">Saltar intro <i class="fas fa-chevron-right"></i></button>
		</div>
	<?php endif; ?>
	
	<?php if($agent->isMobile()): ?>
		
		<section class="ajuste_menu" id="acordeon_mobil">
			<div class="container">
				<div class="row">
					<div class="col angelus">
						<a href="<?php echo e(url('/angelus')); ?>" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="<?php echo e(asset('img/acordeon/logos/angelus_logo.png?v=1')); ?>" class="img-fluid mx-auto d-block" style="height: 70px;">
						</a>
					</div>
				</div>
				<div class="row">
					<div class="col hogar">
						<a href="<?php echo e(url('/linea/hogar/gran-marques')); ?>" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="<?php echo e(asset('/img/logos/isologo-linea-hogar-colchones-carreiro.svg')); ?>" class="img-fluid mx-auto d-block" style="height: 60px;">
						</a>
					</div>
				</div>
				<div class="row">
					<div class="col fcg">
						<a href="<?php echo e(url('/linea/hotelera')); ?>" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="<?php echo e(asset('img/logos/logo_FCG.svg')); ?>" class="img-fluid mx-auto d-block" style="height: 60px;">
						</a>
					</div>
				</div>
				<div class="row">
					<div class="col medico">
						<a href="<?php echo e(url('/linea/clinico')); ?>" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="<?php echo e(asset('img/logos/isologo-linea-medico-hospitalario-colchones-carreiro.svg')); ?>" class="img-fluid mx-auto d-block" style="height: 70px;">
						</a>
					</div>
				</div>
			</div>
		</section>

	<?php else: ?>
		
		<section class="ajuste_menu">
			<div class="unleash_container" id="acordion"> <!-- container -->
			    <div class="any_other_class unleash_slider"> <!-- slider -->

			        <div class="unleash_slide" onclick="window.location.href = '<?php echo e(url('/angelus')); ?>'"> <!-- slide -->
			            <video loop muted preload="auto" poster="<?php echo e(asset('img/acordeon/angelus.webp?v=5')); ?>">
			                <source src="<?php echo e(asset('video/acordeon/angelus.mp4?v=4')); ?>" type="video/mp4">
			            </video>
			            <img src="<?php echo e(asset('img/acordeon/angelus.webp?v=5')); ?>" class="h-100" alt="Recubrimientos industriales<?php echo e(config('app.name')); ?>" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="<?php echo e(asset('img/logos/angelus.svg')); ?>" class="mb-4">
			                <p class="text-white">Con la experiencia ganada desde el año 1970, elaboramos cuidadosamente a mano… Angelus, conjugando las más finas materias primas y los mejores sistemas de descanso, para conseguir que sueñes en “El lugar más tranquilo del mundo®”.</p>
			                <div class="text-verde-fuerte text-right">
			                    <a href="<?php echo e(url('/angelus')); ?>" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-verde-fuerte">Sorpréndete</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide" onclick="window.location.href = '<?php echo e(url('/linea/hogar/gran-marques')); ?>'"> <!-- slide -->
			            <video loop muted preload="auto" poster="<?php echo e(asset('img/acordeon/hogar.webp?v=5')); ?>">
			                <source src="<?php echo e(asset('video/acordeon/hogar.mp4?v=2')); ?>" type="video/mp4">
			            </video>
			            <img src="<?php echo e(asset('img/acordeon/hogar.webp?v=5')); ?>" class="h-100" alt="Investigación y desarrollo <?php echo e(config('app.name')); ?>" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="<?php echo e(asset('img/logos/hogar.svg')); ?>" class="mb-4">
			                <p class="text-white">Inicia tu día con un gran descanso y descubre porqué somos el colchón consentido de todo México. 50 años fabricando noches placenteras para días grandiosos.</p>
			                <div class="text-morado text-right">
			                    <a href="<?php echo e(url('/linea/hogar/gran-marques')); ?>" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-morado">Conócenos</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide" onclick="window.location.href = '<?php echo e(url('/linea/hotelera')); ?>'"> <!-- slide -->
			            <video loop muted preload="auto" poster="<?php echo e(asset('img/acordeon/fcg.webp?v=4')); ?>">
			                <source src="<?php echo e(asset('video/acordeon/FCG.mp4?v=3')); ?>" type="video/mp4">
			            </video>
			            <img src="<?php echo e(asset('img/acordeon/fcg.webp?v=4')); ?>" class="h-100" alt="Recubrimientos arquitectónicos <?php echo e(config('app.name')); ?>" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="<?php echo e(asset('img/logos/FCG.svg')); ?>" class="mb-4">
			                <p class="text-vwhite">Nuestro colchón de línea hotelera es insuperable, fabricados con la más alta calidad en materias primas y sistemas de descanso, satisfacemos los requerimientos más exigentes de nuestros clientes hoteleros, garantizando la satisfacción total de sus huéspedes; calidad que nos ubica dentro de las mejores cadenas hoteleras alrededor del mundo.</p>
			               	<div class="text-verde-claro text-right">
			                    <a href="<?php echo e(url('/linea/hotelera')); ?>" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-verde-claro">Descúbralo</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			               	</div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide" onclick="window.location.href = '<?php echo e(url('/linea/clinico')); ?>'"> <!-- slide -->
			            <video loop muted preload="auto" poster="<?php echo e(asset('img/acordeon/medico.jpg?v=2')); ?>">
			                <source src="<?php echo e(asset('video/acordeon/medico.mp4?v=2')); ?>" type="video/mp4">
			            </video>
			            <img src="<?php echo e(asset('img/acordeon/medico.jpg?v=2')); ?>" class="h-100" alt="Servicio integral <?php echo e(config('app.name')); ?>" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="<?php echo e(asset('img/logos/medico.svg')); ?>" class="mb-4">
			                <p class="text-white">Es primordial la comodidad y el descanso que sus pacientes necesitan para una rápida recuperación; nuestro colchón Médico Hospitalario es perfecto para esa tarea, ya que está fabricado con espumas de alta calidad que brindan una grata sensación de comodidad a sus pacientes.</p>
			                <div class="text-amarillo text-right">
			                    <a href="<?php echo e(url('/linea/clinico')); ?>" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-amarillo">Confíe</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			    </div> <!-- end slider -->
			</div> <!-- end container -->
		</section>

	<?php endif; ?>

	

	
	
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- Modal Temporal-->
	<div class="video-container">
		<div>
			<video controls <?php echo e($agent->isMobile() ? 'muted' : ''); ?>>
				<source src="<?php echo e(asset('video/expo.webm')); ?>" type="video/webm">
				<source src="<?php echo e(asset('video/expo.mp4')); ?>" type="video/mp4">
				<source src="<?php echo e(asset('video/expo.ogg')); ?>" type="video/ogg">
			</video>
		</div>
		<i class="text-white fa-3x far fa-times-circle"></i>
	</div>
	
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>?v=1"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('numscroller/numscroller-1.0.js')); ?>"></script>
    
    <script src="<?php echo e(asset('aos-master/aos.js')); ?>"></script>
    
    <script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('owl-carousel/owl.carousel.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/index.js?v=1')); ?>"></script>

    <script src="<?php echo e(asset('js/modernizr.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.unleash.3.js')); ?>"></script>
    <script>
        $(document).ready(function() {

            $('body').on('click', '.fa-angle-up', function(event) {
            	event.preventDefault();
            	$(this).removeClass('fa-angle-up').addClass('fa-angle-down');
            	$(this).siblings('img').removeClass('d-block').fadeOut();
            	$(this).parents('.col').addClass('h100');
            	$(this).parents('.row').siblings('div').hide();
            	$(this).parent('div').addClass('flex-column justify-content-end');
            	$(this).siblings('div').slideDown();
            });

            $('body').on('click', '.fa-angle-down', function(event) {
            	event.preventDefault();
            	$(this).siblings('div').slideUp();
            	$(this).removeClass('fa-angle-down').addClass('fa-angle-up');
            	$(this).siblings('img').addClass('d-block').fadeIn();
            	$(this).parents('.col').removeClass('h100');
            	$(this).parents('.row').siblings('div').fadeIn();
            	$(this).parent('div').removeClass('flex-column justify-content-end');
            });
        });
    </script>
    <script>
    	var path = '<?php echo e(Request::root()); ?>';
    	// ocultar todo el body
    	var get = '<?php echo e(( isset($_GET['m']) ? true : isset($_GET['contactanos']) ) ? true : false); ?>';

    	if (get) {
    		$(".unleash_slider").unleash({
    		    slide_width: "40%",
    		    duration: 700,
    		    slide_duration: 6000,
    		    slideshow: false,
    		    initially_open_slide: 0,
    		    hide_controls: true,
    		    pause_onmouseover: true,
    		    open_event: 'mouseover',
    		    collapse_on_mouseout: true
    		});
    	}
    	// mostar modal contacto
    	var contactanos = '<?php echo e(isset($_GET['contactanos'])); ?>';
    	$(document).ready(function(){

    		// $('#modal_temporal').modal('show')

    	    $('#index-video').on('ended',function(){

    	    	saltar_intro()
    	    	
    	    });

    	    // var audioElement = document.createElement('audio');
    	    // audioElement.setAttribute('src', '<?php echo e(asset('audio/Jingle.mp3')); ?>');
    	    // audioElement.volume = 0.1;

    	    // audioElement.addEventListener('ended', function() {
    	    // 	this.remove();
    	    // }, false);

    	    // $('#boton-con-manita').click(function(event) {
    	    // 	audioElement.play();
    	    	
    	    // });
    	});

    	function saltar_intro() {
    		$('body > section').show();

    		$(".unleash_slider").unleash({
    		    slide_width: "40%",
    		    duration: 700,
    		    slide_duration: 6000,
    		    slideshow: false,
    		    initially_open_slide: 0,
    		    hide_controls: true,
    		    pause_onmouseover: true,
    		    open_event: 'mouseover',
    		    collapse_on_mouseout: true
    		});

    		$('#index-video').parent('.index-video-wrapper').fadeOut('slow', function() {
    			$(this).remove();
    			$('#carousel').slick();
    		});
    		
    		// $('#boton-con-manita').fadeIn('slow');
    	}

    	$('.scroll').click(function(event) {
    		event.preventDefault();
    		console.log('scroll')
    		$('#menu_mobil').fadeOut();
    		var target = $(this).attr('href');
    		$('html, body').animate({
    			scrollTop: $(target).offset().top - 66
    		}, 800);
    	});
    </script>
</body>
</html>