<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>?v=1" >
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="<?php echo e($descripcion); ?>" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/redes-sociales/fcg.jpg')); ?>" />
	<meta property="og:description" content="<?php echo e($descripcion); ?>" />
	
	<link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('Justified-Gallery/css/justifiedGallery.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('colorbox-master/colorbox.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css?v=2')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css?v=1?v=1')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/hotelero.css?v=14')); ?>">
</head>
<body>
	
	<div id="loader" class="d-flex align-items-start justify-content-center">
		
	</div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<section id="hotelero" class="d-flex align-items-center ajuste_menu py-5">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-sm col-md-4">
					<div class="px-3">
						<div class="carousel-slick slider-aux slider-sync" id="slider-descripcion">
							<div>
								<h2 class="raleway_regular h4 mb-0 azul text-uppercase">HOTELERO Dream Maker</h2>
								<h1 class="h3 text-white raleway_regular text-right text-lowercase pr-3"><strong>Multizone (Rest-Gel) Eurotop</strong></h1>
								<img src="<?php echo e(asset('img/colchones/hotelero/Dream-Maker-Multizone-(Rest-Gel)-Eurotop.png?v=1')); ?>" alt="Colchon Dream Maker Multizone (Rest-Gel) Eurotop Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none">
								<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>*Todos nuestros colchones de la línea DreamsPack® se entregan empaquetados al vacío.</small></p>
							</div>
							<div>
								<h2 class="raleway_regular h4 mb-0 azul text-uppercase">HOTELERO Tender Dreams</h2>
								<h1 class="h3 text-white raleway_regular text-right text-lowercase pr-3"><strong>Multizone (Rest Gel) PT</strong></h1>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-Tender-Dreams-Multizone-(Rest-Gel)-PT.png?v=1')); ?>" alt="Colchon Hotelero Tender Dreams Multizone (Rest Gel) PT Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none">
								<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>*Todos nuestros colchones de la línea DreamsPack® se entregan empaquetados al vacío.</small></p>
							</div>
							<div>
								<h2 class="raleway_regular h4 mb-0 azul text-uppercase">HOTELERO Fluffy</h2>
								<h1 class="h3 text-white raleway_regular text-right text-lowercase pr-3"><strong>Multizone (Rest Gel) Doble PT</strong></h1>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-Fluffy-Multizone-(Rest-Gel)-Doble-PT.png?v=1')); ?>" alt="Colchon Hotelero Fluffy Multizone (Rest Gel) Doble PT Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none">
								<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>*Todos nuestros colchones de la línea DreamsPack® se entregan empaquetados al vacío.</small></p>
							</div>
							<div>
								<h2 class="raleway_regular h4 mb-0 azul text-uppercase">HOTELERO Gran Clase</h2>
								<h1 class="h3 text-white raleway_regular text-right text-lowercase pr-3"><strong>Multizone Rest Gel Tight Top</strong></h1>
								<img src="<?php echo e(asset('img/colchones/hotelero/Gran-Clase-Multizone-Rest-Gel-Tight-Top.png?v=1')); ?>" alt="Colchon Gran Clase Multizone Rest Gel Tight Top Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none">
								<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>*Todos nuestros colchones de la línea DreamsPack® se entregan empaquetados al vacío.</small></p>
							</div>
							<div>
								<h2 class="raleway_regular h4 mb-0 azul text-uppercase">HOTELERO</h2>
								<h1 class="h3 text-white raleway_regular text-right text-lowercase pr-3"><strong>5 Estrellas</strong></h1>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-5-Estrellas.png?v=1')); ?>" alt="Colchon Hotelero 5 Estrellas Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none">
								<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>*Todos nuestros colchones de la línea DreamsPack® se entregan empaquetados al vacío.</small></p>
							</div>
						</div>
						<div class="row align-items-center d-none d-md-flex">
							<div class="col-12 my-4">
								<img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" style="max-height: 120px;">
							</div>
							<div class="col text-center">
								<a href="mailto:ventas@colchonescarreiro.com" class="btn btn-primary"><i class="fa fa-envelope" aria-hidden="true"></i> <small>CONTÁCTENOS</small></a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm col-md-7">
					<div class="px-3">
						<div class="carousel-slick d-none d-md-block slider-sync" id="slider-imagen">
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Dream-Maker-Multizone-(Rest-Gel)-Eurotop.png?v=1')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" >
								
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-Tender-Dreams-Multizone-(Rest-Gel)-PT.png?v=1')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" >
								
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-Fluffy-Multizone-(Rest-Gel)-Doble-PT.png?v=1')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" >
								
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Gran-Clase-Multizone-Rest-Gel-Tight-Top.png?v=1')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" >
								
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-5-Estrellas.png?v=1')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" >
								
							</div>
						</div>
						<div class="slider-sync" id="slider-mini">
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Dream-Maker-Multizone-(Rest-Gel)-Eurotop.png?v=1')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-Tender-Dreams-Multizone-(Rest-Gel)-PT.png?v=1')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-Fluffy-Multizone-(Rest-Gel)-Doble-PT.png?v=1')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Gran-Clase-Multizone-Rest-Gel-Tight-Top.png?v=1')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
							</div>
							<div>
								<img src="<?php echo e(asset('img/colchones/hotelero/Hotelero-5-Estrellas.png?v=1')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
							</div>
						</div>
						<div class="row align-items-center d-md-none">
							<div class="col">
								<img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" width="100">
							</div>
							<div class="col">
								<button class="btn btn-primary" data-toggle="modal" data-target="#modal-contacto"><i class="fa fa-envelope" aria-hidden="true"></i> <small>CONTÁCTENOS</small></button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- Modal -->
	<div class="modal fade" id="modal-imagen-alta" tabindex="-1" role="dialog" aria-labelledby="modal-imagen-altaLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header d-none">
					<h5 class="modal-title" id="modal-imagen-altaLabel">Modal title</h5>
				</div>
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<img src="" class="img-fluid mx-auto d-block lazy-load">
				</div>
				<div class="modal-footer d-none">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn btn-primary">Save changes</button>
				</div>
			</div>
		</div>
	</div>
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-dream-maker-linea-hotelero-colchones-carreiro.png?v=1')); ?>" class="d-none">
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-fluffy-linea-hogar-colchones-carreiro.png?v=1')); ?>" class="d-none">
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-gran-duque-linea-hotelero-colchones-carreiro.png?v=1')); ?>" class="d-none">
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-tender-dreams-linea-hotelero-colchones-carreiro.png?v=1')); ?>" class="d-none">
	<!-- Modal -->
	<div class="modal fade" id="modal-video" tabindex="-1" role="dialog" aria-labelledby="modal-videoLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close" style="position: absolute;top: -5px;right: 0;">
						<span aria-hidden="true">&times;</span>
					</button>
					<div class="embed-responsive embed-responsive-16by9">
						<video class="embed-responsive-item" controls autoplay>
							Tu navegador no puede reproducir este video
						</video>
					</div>
				</div>
				
			</div>
		</div>
	</div>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>?v=1"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js')); ?>"></script>
	
	<script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
	
	<script src="<?php echo e(asset('Justified-Gallery/js/jquery.justifiedGallery.min.js')); ?>"></script>
	<script src="<?php echo e(asset('colorbox-master/jquery.colorbox-min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/hotelero-dreams-pack.js')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
</body>
</html>