<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo = "Historia Colchones Carreiro";
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
   
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/historia/redes-socilales-colchones-carreiro.jpg')); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />
	
    <link rel="stylesheet" href="<?php echo e(asset('aos-master/aos.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css?v=1')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/historia.css')); ?>">
</head>
<body>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<section id="cd-timeline" class="cd-container ajuste_menu">
		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-picture">
				
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-right">
				<h2 class="azul">NUESTRO NACIMIENTO</h2>
				<p class="azul">En la década de los 70's en CDMX nace una pequeña fábrica de colchones tomando como punto de partida, un local de 700 m2.</p>
				<img src="<?php echo e(asset('img/historia/nuestro-nacimiento-colchones-carreiro.jpg')); ?>" alt="Nuestro Nacimiento <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
				
				<span class="cd-date azul">Década de los 70's</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-movie">
				
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-left">
				<h2 class="azul">CRECIENDO DÍA A DÍA</h2>
				<p class="azul">Es a partir de esta década, en  que Colchones Carreiro empieza a crecer continuamente en personal, unidades de transporte, bodegas, maquinaria y se renta una bodega continua de otros 700 m2.</p>
				<img src="<?php echo e(asset('img/historia/creciendo-dia-a-dia-colchones-carreiro.jpg')); ?>" alt="Creciendo dia a Dia <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
				
				<span class="cd-date azul">Década de los 80's</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-picture">
				
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-right">
				<h2 class="azul">CON PASO FIRME</h2>
				<p class="azul">El 24 de Junio de 1994 se inician labores en las instalaciones actuales de Colchones Carreiro.</p>
				<img src="<?php echo e(asset('img/historia/con-paso-firme-colchones-carreiro.jpg')); ?>" alt="Con Paso Firme <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
				
				<span class="cd-date azul">Década de los 90's</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-movie">
				
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-left">
				<h2 class="azul">TECNOLOGÍA DE PUNTA</h2>
				<p class="azul">Se establece un sistema automatizado de producción, contamos con maquinaria de última tecnología. Tenemos una de las plantas automatizadas más importantes del país.</p>
				<img src="<?php echo e(asset('img/historia/tecnologia-de-punta-colchones-carreiro.jpg')); ?>" alt="tecnologia de punta <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
				
				<span class="cd-date azul">Los 2000</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-location">
				
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-right">
				<h2 class="azul">SATISFACCIÓN TOTAL</h2>
				<p class="azul">Colchones Carreiro sigue creciendo, abriendo sus puertas con sucursales en diferentes estados de la República Mexicana. Teniendo presencia, no sólo en México, sino en otros países.</p>
				<img src="<?php echo e(asset('img/historia/satisfaccion-total-colchones-carreiro.jpg')); ?>" alt="satisfacción Total <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
				
				<span class="cd-date azul">ACTUALIDAD</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		
	</section> <!-- cd-timeline -->
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
	
    <script src="<?php echo e(asset('aos-master/aos.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/historia.js')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
</body>
</html>