<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo ="Colchones Carreiro";
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('animate-css/animate.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('aos-master/aos.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>Colchones Carreiro</title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/logos/imagotipo-azul-colchones-carreiro.svg')); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />




	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/font-awesome/css/font-awesome.css')); ?>">    
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/settings.css')); ?>">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/layers.css')); ?>">            
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/navigation.css')); ?>">


	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/index.css')); ?>">
</head>
<body>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php if(!isset($_GET['m'])): ?>
	<!-- SLIDER EXAMPLE -->
	<section class="example" id="slider-revolution">
		<article class="content">
			<div id="rev_slider_24_1_wrapper" class="rev_slider_wrapper fullscreen-container" data-alias="website-intro" data-source="gallery" style="background:#000000;padding:0px;">
				<!-- START REVOLUTION SLIDER 5.4.1 fullscreen mode -->
				<div id="rev_slider_24_1" class="rev_slider fullscreenbanner tiny_bullet_slider" style="display:none;" data-version="5.4.1">
					<ul>	<!-- SLIDE  -->
						<li data-index="rs-67" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="600"  data-thumb="<?php echo e(asset('img/fondos/linea-hotelero-mini-colchones-carreiro.jpg')); ?>"  data-rotate="0"  data-saveperformance="off"  data-title="Slide" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="" data-slicey_shadow="0px 0px 0px 0px transparent">
							<!-- MAIN IMAGE -->
							<img src="<?php echo e(asset('img/fondos/linea-hotelero-colchones-carreiro.jpg')); ?>"  alt="Colchones Carreiro El lugar mas tranquilo del mundo" data-bgparallax="5" data-bgposition="center center" data-kenburns="on" data-duration="5000" data-ease="Power2.easeInOut" data-scalestart="100" data-scaleend="100" data-rotatestart="0" data-rotateend="0" data-blurstart="20" data-blurend="0" data-offsetstart="0 0" data-offsetend="0 0" class="rev-slidebg" data-no-retina  data-bgfit="cover" data-bgrepeat="no-repeat">
							<!-- LAYERS -->

							<!-- LAYER NR. 1 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-9" 
								 data-x="['center','center','center','center']" data-hoffset="['-112','-43','-81','44']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['-219','-184','-185','182']" 
								data-width="['250','250','150','150']"
								data-height="['150','150','100','100']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":300,"speed":1000,"frame":"0","from":"rX:0deg;rY:0deg;rZ:0deg;sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3700","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 5;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 2 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-10" 
								 data-x="['center','center','center','center']" data-hoffset="['151','228','224','117']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['-212','-159','71','-222']" 
								data-width="['150','150','100','100']"
								data-height="['200','150','150','150']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":350,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3650","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 6;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 3 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-29" 
								 data-x="['center','center','center','center']" data-hoffset="['339','-442','104','-159']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['2','165','-172','219']" 
								data-width="['250','250','150','150']"
								data-height="['150','150','100','100']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":400,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3600","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 7;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 4 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-12" 
								 data-x="['center','center','center','center']" data-hoffset="['162','216','-239','193']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['195','245','6','146']" 
								data-width="['250','250','100','100']"
								data-height="150"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":450,"speed":1000,"frame":"0","from":"opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3550","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 8;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 5 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-34" 
								 data-x="['center','center','center','center']" data-hoffset="['-186','-119','273','-223']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['269','217','-121','69']" 
								data-width="['300','300','150','150']"
								data-height="['200','200','150','150']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":500,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3500","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 9;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 6 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-11" 
								 data-x="['center','center','center','center']" data-hoffset="['-325','292','162','-34']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['3','55','-275','-174']" 
								data-width="150"
								data-height="['250','150','50','50']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":550,"speed":1000,"frame":"0","from":"opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3450","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 10;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 7 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-27" 
								 data-x="['center','center','center','center']" data-hoffset="['-429','523','-190','-306']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['-327','173','181','480']" 
								data-width="['250','250','150','150']"
								data-height="['300','300','150','150']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="300" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":320,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3680","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 11;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 8 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-28" 
								 data-x="['center','center','center','center']" data-hoffset="['422','-409','208','225']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['-245','-72','294','-14']" 
								data-width="['300','300','150','150']"
								data-height="['250','250','100','100']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="300" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":360,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3640","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 12;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 9 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-30" 
								 data-x="['center','center','center','center']" data-hoffset="['549','-445','28','58']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['236','400','316','287']" 
								data-width="['300','300','150','200']"
								data-height="['250','250','150','50']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="300" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":400,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3600","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 13;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 10 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-31" 
								 data-x="['center','center','center','center']" data-hoffset="['-522','492','-151','262']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['339','-180','330','-141']" 
								data-width="['300','300','150','150']"
								data-height="['250','250','100','100']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="300" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":440,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3560","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 14;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 11 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-32" 
								 data-x="['center','center','center','center']" data-hoffset="['-588','-375','-253','-207']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['72','-328','-172','-111']" 
								data-width="['300','300','150','150']"
								data-height="['200','200','150','150']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="300" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":480,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3520","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 15;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 12 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-33" 
								 data-x="['center','center','center','center']" data-hoffset="['-37','73','-76','-100']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['-401','-340','-293','-246']" 
								data-width="['450','400','250','250']"
								data-height="['100','100','50','50']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":310,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3690","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 16;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 13 -->
							<div class="tp-caption tp-shape tp-shapewrapper tp-slicey  tp-resizeme" 
								 id="slide-67-layer-35" 
								 data-x="['center','center','center','center']" data-hoffset="['186','38','116','17']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['363','402','190','395']" 
								data-width="['350','400','250','250']"
								data-height="['100','100','50','50']"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-slicey_offset="250" 
								data-slicey_blurstart="0" 
								data-slicey_blurend="20" 
								data-responsive_offset="on" 

								data-frames='[{"delay":340,"speed":1000,"frame":"0","from":"sX:1;sY:1;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"+3660","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 17;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 14 -->
							<div class="tp-caption tp-shape tp-shapewrapper " 
								 id="slide-67-layer-1" 
								 data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
								 data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
								data-width="full"
								data-height="full"
								data-whitespace="nowrap"
					 
								data-type="shape" 
								data-basealign="slide" 
								data-responsive_offset="off" 
								data-responsive="off"
								data-frames='[{"delay":10,"speed":500,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power4.easeOut"},{"delay":"wait","speed":500,"frame":"999","to":"opacity:0;","ease":"Power4.easeOut"}]'
								data-textAlign="['inherit','inherit','inherit','inherit']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 18;background-color:rgba(0, 0, 0, 0.5);"> </div>

							<!-- LAYER NR. 15 -->
							<div class="tp-caption tp-resizeme" 
								data-x="center" data-hoffset="0"
							    data-y="top" data-voffset="['0','0','0','0']"
							 
							    data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:0.9;sY:0.9;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":500,"frame":"999","to":"sX:0.9;sY:0.9;opacity:0;fb:20px;","ease":"Power3.easeInOut"},{"frame":"hover","speed":"0","ease":"Linear.easeNone","to":"o:1;rX:0;rY:0;rZ:0;z:0;fb:0;","style":"c:rgba(255,255,255,1);bs:solid;bw:0 0 0 0;"}]'
							 
							    data-type="image"
							    data-responsive_offset="on"

							    data-width="['auto']"
							    data-height="['auto']"
						 		style="z-index: 19;">
						 			<img src="<?php echo e(asset('img/logos/isologo-colchones-carreiro-con-angel.png')); ?>" alt="Imagotipo Colchones Carreiro" data-ww="['400px']" data-hh="['auto']" data-no-retina></div>
								<!-- END IMAGE LAYER -->

							<!-- LAYER NR. 16 -->
							<div class="tp-caption tp-resizeme raleway_regular blanco" 
								id="slide-67-layer-2" 
								data-x="['center']" data-hoffset="['0','0','0','0']" 
								data-y="['top']" data-voffset="['220','220','220','220']" 
								data-fontsize="['30','30','30','30']"
								data-lineheight="['40','35','30','30']"
								data-width="['100%']"
								data-height="['none']"
					 
								data-type="text"
								data-whitespace="['normal']" 
								data-responsive_offset="on" 

								data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:0.9;sY:0.9;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":500,"frame":"999","to":"sX:0.9;sY:0.9;opacity:0;fb:20px;","ease":"Power3.easeInOut"}]'
								data-textAlign="['center','center','center','center']"
								data-paddingtop="[0,0,0,0]"
								data-paddingright="[0,0,0,0]"
								data-paddingbottom="[0,0,0,0]"
								data-paddingleft="[0,0,0,0]"

								style="z-index: 20;">Que sueñes con los angelitos<sup id="registrada">®</sup></div>

							<!-- LAYER NR. 17 -->
							<a class="tp-caption tp-resizeme blanco raleway_regular" 
					 			href="#"
					 			id="slide-67-layer-7" 
								data-x="['center']" data-hoffset="['0','0','0','0']" 
								data-y="['top']" data-voffset="['300','300','300','300']" 
								data-width="['255','255','380','380']"
								data-height="['65','65','100','100']"

								data-whitespace="nowrap"
								data-fontsize="['20','20','30','30']"
								data-lineheight="['20','20','30','30']"
					 
								data-type="button" 
								data-actions=''
								data-responsive_offset="on" 

								data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:0.9;sY:0.9;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":500,"frame":"999","to":"sX:0.9;sY:0.9;opacity:0;fb:20px;","ease":"Power3.easeInOut"},{"frame":"hover","speed":"0","ease":"Linear.easeNone","to":"o:1;rX:0;rY:0;rZ:0;z:0;fb:0;","style":"c:rgba(255,255,255,1);bs:solid;bw:0 0 0 0;"}]'

								data-textAlign="['center','center','center','center']"
								data-paddingtop="[10,10,17,17,17]"
								data-paddingright="[10]"
								data-paddingbottom="[10]"
								data-paddingleft="[10]"

								style="z-index: 21; background-color:rgba(0,0,0,.41);border: 1px solid white;cursor:pointer!important;text-decoration: none;">ADÉNTRATE AL MUNDO<br>DEL <span class="naranja">DESCANSO</span>
							</a>

							<div class="tp-caption tp-resizeme animated infinite pulse" 
 
							    data-frames='[{"delay":1000,"speed":2000,"frame":"0","from":"sX:0.9;sY:0.9;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power3.easeInOut"},{"delay":"wait","speed":500,"frame":"999","to":"sX:0.9;sY:0.9;opacity:0;fb:20px;","ease":"Power3.easeInOut"},{"frame":"hover","speed":"0","ease":"Linear.easeNone","to":"o:1;rX:0;rY:0;rZ:0;z:0;fb:0;","style":"c:rgba(255,255,255,1);bs:solid;bw:0 0 0 0;"}]'
							 
							     data-type="image" 
							     data-x="['center']" data-hoffset="['-110','-110','-160','-160']" 
								data-y="['top']" data-voffset="['320','320','320','320']"  
							     data-width="['auto']"
							     data-height="['auto']"
							 
							style="z-index: 22;"><img src="<?php echo e(asset('img/iconos/manita-colchones-carreiro.svg')); ?>" alt="Donde compro mi colchon" data-ww="['50px']"></div>
						</li>
					</ul>
					<div class="tp-bannertimer tp-bottom" style="height: 5px; background: rgb(87,202,133);"></div>
				</div>
			</div><!-- END REVOLUTION SLIDER -->
		</article>
	</section> 
	<?php endif; ?>
	<section id="panels" class="ajuste_menu">
		<div class="d-flex flex-row justify-content-center flex-wrap">
			<?php
				use Jenssegers\Agent\Agent;
				$agent = new Agent();
			?>
			<div class="animacion" <?php if($agent->isAndroidOS()): ?> style="min-height: calc(100vh - 122px);" <?php endif; ?>>
				<div class="text-center">
					<img src="<?php echo e(asset('img/logos/isologo-linea-hogar-colchones-carreiro.svg')); ?>" alt="Linea Hogar <?php echo e($titulo); ?>" height="65">
					<h6 class="azul raleway_regular mt-4 animacion">Nos aseguramos que tu día<br>a día sea grandioso,<br>Inicialo con un <span class="raleway_bold">gran descanso.</span></h6>
				</div>
				<img src="<?php echo e(asset('img/fondos/linea-hogar-colchones-carreiro-1.jpg')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
			</div>
			<div class="animacion">
				<div class="text-center">
					<img src="<?php echo e(asset('img/logos/isologo-linea-hotelera-colchones-carreiro.svg')); ?>" alt="Line Hotelera <?php echo e($titulo); ?>" height="70">
					<h6 class="azul raleway_regular mt-4 animacion">Estamos dentro de las mejores<br>cadenas hoteleras alrededor del mundo,<br>compruebe porqué somos la mejor opción<br>y la del <span class="raleway_bold">descanso de sus huéspedes.</span></h6>
				</div>
				<img src="<?php echo e(asset('img/fondos/linea-hotelero-colchones-carreiro-1.jpg')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
			</div>
			<div class="animacion">
				<div class="text-center">
					<img src="<?php echo e(asset('img/logos/isologo-linea-medico-hospitalario-colchones-carreiro.svg')); ?>" alt="Colchon Clinico <?php echo e($titulo); ?>" height="70">
					<h6 class="azul raleway_regular mt-4 animacion">Sus pacientes necesitan<br><span class="raleway_bold">el mejor de los descansos</span>,<br>para una rápida recuperación.</h6>
				</div>
				<img src="<?php echo e(asset('img/fondos/linea-hospital-colchones-carreiro.jpg')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
			</div>
		</div>
		<div id="scroll">
			<h6 class="raleway_medium blanco"><small>DESPLAZA HACIA ABAJO</small></h6>
			<a href="#doctora"><span></span></a>
		</div>
		<div class="degradado"></div>
	</section>
	<section id="doctora" class="py-5 py-sm-0">
		<div class="container-fluid">
			<div class="row align-items-center">
				<div class="col-12 col-md-5 pointer" data-aos="fade-right" style="cursor: pointer;">
					<p class="raleway_bold_italic azul h6">Mejora tu calidad de sueño y la de tus seres queridos,  visita mi blog y escucha mis podcast. Mi objetivo es orientarte para aumentar tu bienestar y el de tu familia.</p>
					<img src="<?php echo e(asset('img/comprar/doctora-descanso-colchones-carreiro.png')); ?>" alt="Doctora Descanso Colchones Carreiro" class="fondo_doctora pointer">
				</div>
				<div class="col-12 col-sm-6 col-md-3 py-4">
					<h3 class="raleway_bold azul text-center">¿Dónde compro mi</h3>
					<div class="d-flex justify-content-center">
						<div>
							<img src="<?php echo e(asset('img/logos/imagotipo-azul-colchones-carreiro.svg')); ?>" alt="Imagotipo Colchones Carreiro" class="img-fluid d-inline-block"><span class="d-inline-block raleway_bold azul" style="font-size: 2em;vertical-align: middle;line-height: 0; width: 10%;"> ?</span>
						</div>
					</div>
					<div>
						<a href="<?php echo e(url('/tiendas')); ?>">
							<img src="<?php echo e(asset('img/iconos/donde-compro-mi-colchon_.svg')); ?>" alt="donde compro Colchones Carreiro" class="mx-auto img-fluid d-block pt-2 animated infinite pulse">
						</a>
						<a href="<?php echo e(url('/tiendas')); ?>">
							<img src="<?php echo e(asset('img/iconos/manita-colchones-carreiro.svg')); ?>" alt="donde compro Colchones Carreiro" height="60">
						</a>
					</div>
				</div>
				<div class="col-12 col-sm-6 col-md-4 py-sm-4" data-aos="fade-left">
					<img src="<?php echo e(asset('img/comprar/localizar-colchon-carreiro.svg')); ?>" alt="Localizar Colchones Carreiro" class="mx-auto d-block animated infinite pulse" height="30">
					<img src="<?php echo e(asset('img/comprar/amo-mi-colchon-carreiro.png')); ?>" alt="Amo mi Colchones Carreiro" class="mx-auto img-fluid d-block">
				</div>
			</div>
		</div>
	</section>
	<section id="numeros">
		<div class="container-fluid">
			<div class="row">
				<div class="col-6 col-sm-3 text-center">
					<img src="<?php echo e(asset('img/iconos/puntos-de-venta-colchones-carreiro.svg')); ?>" alt="Puntos de Venta Colchones Carreiro" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">PUNTOS DE VENTA</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='1100' data-delay='10' data-increment='10'>1100</span>
				</div>
				<div class="col-6 col-sm-3 text-center">
					<img src="<?php echo e(asset('img/iconos/hoteles-donde-estamos-colchones-carreiro.svg')); ?>" alt="Hoteles donde Estamos Colchones Carreiro" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">HOTELES DONDE ESTAMOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='520' data-delay='10' data-increment='10'>520</span>
				</div>
				<div class="col-6 col-sm-3 text-center pt-3 pt-sm-0">
					<img src="<?php echo e(asset('img/iconos/paises-donde-estamos-colchones-carreiro.svg')); ?>" alt="Paises donde Estamos Colchones Carreiro" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">REGIONES DONDE ESTAMOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='9' data-delay='1' data-increment='1'>9</span>
				</div>
				<div class="col-6 col-sm-3 text-center pt-3 pt-sm-0">
					<img src="<?php echo e(asset('img/iconos/clientes-satisfechos-colchones-carreiro.svg')); ?>" alt="Clientes Satisfechos Colchones Carreiro" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">CLIENTES SATISFECHOS</h6>
					<div class="naranja raleway_bold" style="font-size: x-large;line-height: 1;">Más de <span class='numscroller naranja raleway_bold' data-min='1' data-max='10' data-delay='1' data-increment='1' style="font-size: xx-large;">10</span> Millones <br class="d-none d-sm-block"> y <br class="d-sm-none">aumentando</div>
				</div>
			</div>
		</div>
	</section>
	<section id="sistemas" class="py-5">
		<div class="container-fluid">
			<div class="row">
				<div class="col text-center">
					<h4 class="raleway_extra_bold azul mb-5">NUESTROS SISTEMAS DE DESCANSO</h4>
				</div>
			</div>
			<div class="row">
				<div class="col-9 mx-auto">
					<div id="carousel" data-aos="fade-up">
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/multizone-technology-colchones-carreiro.png')); ?>" alt="Multizone Technology <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema de resortes con zonas independientes. </li>
										<li>Se adapta a las necesidades del cuerpo.</li>
										<li>Brinda confort y durabilidad.</li>
										<li>Descanso sin interrupciones.</li>
										<li>Sistema indeformable.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/hight-resistance-colchones-carreiro.png')); ?>" alt="Hight Resistance <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Fibras de poliuretano de alta recuperación.</li>
										<li>Posee mayor acojinamiento multicelular.</li>
										<li>Brinda mayor firmeza y comodidad.</li>
										<li>Capitonado especialmente diseñado para el descanso.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/up-turn-colchones-carreiro.png')); ?>" alt="Up Turn <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema con resortes y materiales de alta resistencia concentrados en una sola cara.</li>
										<li>Colchón 100% duradero.</li>
										<li>Sin necesidad de darle vuelta.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/comfort-tech-colchones-carreiro.png')); ?>" alt="Comfort Tech<?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema de resortes flexibles, que brinda una mejor adaptación al contorno del cuerpo.</li>
										<li>Provee un soporte óptimo para la columna vertebral, aumentando la sensación de confort durante el descanso.</li>
										<li>Gracias a la complexión del resorte, se eliminan los puntos de tensión y se aumenta la durabilidad del colchón.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/smart-fit-colchones-carreiro.png')); ?>" alt="Smart Fit <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Confort total.</li>
										<li>Sistema inteligente que alivia la presión acumulada.</li>
										<li>La espuma viscolástica se adapta 100% al cuerpo.</li>
										<li>Brinda a la espalda una correcta posición.</li>
										<li>Permite un sueño profundo y relajado.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/superior-foam-colchones-carreiro.png')); ?>" alt="Superior Foam <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Unidad de espumas de alta calidad que brindan una mayor firmeza en la columna vertebral.</li>
										<li>Fibras de poliuretano en diferentes densidades que permiten una alta recuperación y durabilidad en el colchón.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/soft-dream-colchones-carreiro.png')); ?>" alt="Soft Dream <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Fibras de poliuretano de alta recuperación.</li>
										<li>Posee mayor acojinamiento multicelular.</li>
										<li>Brinda mayor firmeza y comodidad.</li>
										<li>Capitonado especialmente diseñado para el descanso.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/twist-colchones-carreiro.png')); ?>" alt="Twist <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema con resortes y materiales de alta resistencia concentrados en sus dos caras.</li>
										<li>Colchón 100% duradero.</li>
										<li>Colchón de doble vuelta para mayor durabilidad.</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('numscroller/numscroller-1.0.js')); ?>"></script>
    
    <script src="<?php echo e(asset('aos-master/aos.js')); ?>"></script>
    
    <script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>

    <!-- REVOLUTION JS FILES -->
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>

    
    <script type='text/javascript' src='<?php echo e(asset('slider-revolution/revolution-addons/slicey/js/revolution.addon.slicey.min.js?ver=1.0.0')); ?>'></script>

    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->    
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.actions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.carousel.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.kenburn.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.migration.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.navigation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.parallax.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.video.min.js')); ?>"></script>


    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/index.js')); ?>"></script>
    <script>
    	var path = '<?php echo e(Request::root()); ?>';
    	var get = '<?php echo e(isset($_GET['m'])); ?>';
    </script>
    <script type="text/javascript">
		
		var tpj=jQuery;
		var revapi24;
		tpj(document).ready(function() {
			if(tpj("#rev_slider_24_1").revolution == undefined){
				revslider_showDoubleJqueryError("#rev_slider_24_1");
			}else{
				revapi24 = tpj("#rev_slider_24_1").show().revolution({
					// sliderType:"standard",
					jsFileLocation:"revolution/js/",
					sliderLayout:"fullscreen",
					responsiveLevels: [1200, 992, 768, 576],
					dottedOverlay:"none",
					delay:9000,
					navigation: {
						keyboardNavigation:"off",
						keyboard_direction: "horizontal",
						mouseScrollNavigation:"off",
							mouseScrollReverse:"default",
						onHoverStop:"off"
					},
					parallax: {
						type: 'mouse+scroll',
						origo: 'slidercenter',
						speed: 400,
						levels: [5,10,15,20,25,30,35,40,45,46,47,48,49,50,51,55],
						disable_onmobile: 'on'
					},
					lazyType:"none",
					shadow:0,
					spinner:'spinner3',
					stopLoop:"off",
					stopAfterLoops:-1,
					stopAtSlide:-1,
					shuffle:"off",
					hideThumbsOnMobile:"off",
					hideSliderAtLimit:0,
					hideCaptionAtLimit:0,
					hideAllCaptionAtLilmit:0,
					debugMode:false,
					fallbacks: {
						simplifyAll:"off",
						nextSlideOnWindowFocus:"off",
						disableFocusListener:false,
					}
				});
			}

            if(revapi24) revapi24.revSliderSlicey();
		});	/*ready*/
	</script>
</body>
</html>