<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="<?php echo e($descripcion); ?>" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/redes-sociales/hotel-colchones-carreiro.jpg')); ?>" />
	<meta property="og:description" content="<?php echo e($descripcion); ?>" />
	
	<link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('Justified-Gallery/css/justifiedGallery.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('colorbox-master/colorbox.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css?v=2')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css?v=1')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/hotelero.css?v=11')); ?>">
</head>
<body>
	
	<div id="loader" class="d-flex align-items-start justify-content-center">
		<div>
			<img src="<?php echo e(asset("img/logos/logo first class guest-blanco.svg")); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block my-5">
			<h2 class="text-uppercase text-white lato-medium text-center">Vivamos la experiencia de <br class="d-md-none">ser un <strong class="lato-heavy">gran hotel</strong></h2>
		</div>
	</div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<section id="descripcion" class="ajuste_menu py-5">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 ml-auto">
					<img src="<?php echo e(asset("img/logos/logo first class guest-blanco.svg")); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block my-5" style="max-height: 80px;">
					<p class="lato-light text-white d-none d-lg-block">Nuestros Colchones <span class="lato-heavy">First Class Guest</span> lo tienen todo: Excelente calidad, comodidad inigualable y tecnologías de vanguardia. Muchos huéspedes de los mejores hoteles, se quedan maravillados después de dormir en un <span class="lato-heavy">Colchón Carreiro</span>. Decida ser parte de la experiencia <span class="lato-heavy">First Class Guest</span> y ofrezca a sus huéspedes el mejor descanso para disfrutar sus vacaciones o viaje de negocios. </p>
				</div>
				<div class="col">
					<div class="embed-responsive embed-responsive-16by9">
						<video class="embed-responsive-item" src="<?php echo e(asset('video/fcf.mp4')); ?>" autoplay muted controls loop></video>
					</div>
					<p class="lato-light text-white d-lg-none mt-3">Nuestros Colchones <span class="lato-heavy">First Class Guest</span> lo tienen todo: Excelente calidad, comodidad inigualable y tecnologías de vanguardia. Muchos huéspedes de los mejores hoteles, se quedan maravillados después de dormir en un <span class="lato-heavy">Colchón Carreiro</span>. Decida ser parte de la experiencia <span class="lato-heavy">First Class Guest</span> y ofrezca a sus huéspedes el mejor descanso para disfrutar sus vacaciones o viaje de negocios. </p>
				</div>
			</div>
		</div>
	</section>
	<section id="hotelero" class="d-flex align-items-center">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-sm col-md-4">
					<h2 class="raleway_regular h3 mb-0 pl-3 azul">HOTELERO</h2>
					<div class="carousel-slick slider-aux" id="slider-descripcion">
						<div>
							<h1 class="h3 text-white raleway_regular text-right text-uppercase pr-3"><strong>DREAM MAKER</strong></h1>
							<img src="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Dream Maker Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none imagen-abierta-mobil" style="-webkit-transform: scale(1.2);-moz-transform: scale(1.2);-ms-transform: scale(1.2);-o-transform: scale(1.2);transform: scale(1.2)" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>">
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Nuestra propuesta de diseño para colchón de hoteles se basa en hacer un colchón a la medida de sus necesidades, superando cualquier expectativa. Sabemos que los huéspedes tendrán un descanso adecuado y querrán volver a su hotel.</small></p>
						</div>
						<div>
							<h1 class="h3 text-white raleway_regular text-right text-uppercase pr-3"><strong>Fluffy</strong></h1>
							<img src="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>" alt="Colchon Fluffy Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none imagen-abierta-mobil" style="-webkit-transform: scale(1.2);-moz-transform: scale(1.2);-ms-transform: scale(1.2);-o-transform: scale(1.2);transform: scale(1.2)" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-fluffy-linea-hogar-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>">
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Contamos con colchones para hoteles a precios muy competitivos. Contáctenos, con gusto podemos elaborar una cotización de los colchones perfectos para su hotel de acuerdo a su presupuesto.</small></p>
						</div>
						<div>
							<h1 class="h3 text-white raleway_regular text-right text-uppercase pr-3"><strong>Tender Dreams</strong></h1>
							<img src="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Tender Dreams Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none imagen-abierta-mobil" style="-webkit-transform: scale(1.2);-moz-transform: scale(1.2);-ms-transform: scale(1.2);-o-transform: scale(1.2);transform: scale(1.2)" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>">
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Nuestros colchones son sinónimo de satisfacción y descanso. ¿Le gustaría ofrecer a sus huéspedes el mejor lugar para descansar durante su visita? Somos su mejor opción de colchón hotelero.</small></p>
						</div>
						<div>
							<h1 class="h3 text-white raleway_regular text-right text-uppercase pr-3"><strong>Gran Clase</strong></h1>
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-clase-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Tender Dreams Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none imagen-abierta-mobil" style="-webkit-transform: scale(1.2);-moz-transform: scale(1.2);-ms-transform: scale(1.2);-o-transform: scale(1.2);transform: scale(1.2)" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-gran-clase-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/gran-clase-linea-hotelero-colchones-carreiro.png')); ?>">
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Nuestra propuesta de diseño para colchón de hoteles se basa en hacer un colchón a la medida de sus necesidades, superando cualquier expectativa. Sabemos que los huéspedes tendrán un descanso adecuado y querrán volver a su hotel.</small></p>
						</div>
						<div>
							<h1 class="h3 text-white raleway_regular text-right text-uppercase pr-3"><strong>Gran Duque</strong></h1>
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block d-md-none imagen-abierta-mobil" style="-webkit-transform: scale(1.2);-moz-transform: scale(1.2);-ms-transform: scale(1.2);-o-transform: scale(1.2);transform: scale(1.2)" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>">
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Nuestros colchones son sinónimo de satisfacción y descanso. ¿Le gustaría ofrecer a sus huéspedes el mejor lugar para descansar durante su visita? Somos su mejor opción de colchón hotelero.</small></p>
						</div>
					</div>
					<div class="row align-items-center d-none d-md-flex">
						<div class="col-12 my-4">
							<img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" style="max-height: 120px;">
						</div>
						<div class="col text-center">
							<a href="mailto:ventas@colchonescarreiro.com" class="btn btn-primary"><i class="fa fa-envelope" aria-hidden="true"></i> <small>CONTÁCTENOS</small></a>
						</div>
					</div>
				</div>
				<div class="col-sm col-md-7 offset-lg-1 pr-0">
					<div class="carousel-slick d-none d-md-block" id="slider-imagen">
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Dream Maker Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/dream-maker.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>" alt="Colchon Fluffy Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-fluffy-linea-hogar-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/fluffy.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Tender Dreams Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/tender-dreams.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-clase-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Tender Dreams Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-gran-clase-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/gran-clase-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/gran-clase.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/hotelero-gran-duque.png')); ?>"></i>
						</div>
					</div>
					<div class="row" id="carousel-mini">
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" alt="Dream Maker <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>" alt="Fluffy <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" alt="Tender Dreams <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-clase-linea-hotelero-colchones-carreiro.png')); ?>" alt="Gran Clase <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
					</div>
					<div class="row align-items-center d-md-none">
						<div class="col">
							<img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" width="100">
						</div>
						<div class="col">
							<button class="btn btn-primary" data-toggle="modal" data-target="#modal-contacto"><i class="fa fa-envelope" aria-hidden="true"></i> <small>CONTÁCTENOS</small></button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section id="sistemas" class="py-5">
		<div class="container">
			<div class="row">
				<div class="col lato-medium text-white text-center">
					<h3 class="h5 font-weight-bold">NUESTROS SISTEMAS DE DESCANSO</h3>
					<p class="mb-0">Contamos con una gran variedad de tecnologías que nos permiten generan la combinación perfecta de sistemas de descanso para cada hotel.</p>
					<p>Le aseguramos que sus huéspedes desearán volver a hospedarse con usted y descansar como nunca antes lo habían hecho.</p>
				</div>
			</div>
			<div class="row">
				<div class="col-md-9 mx-auto">
					<div id="sistemas-gallery">
						<?php $__currentLoopData = glob('./img/sistemas-iconos/*.{svg}', GLOB_BRACE); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<a href="<?php echo e(asset(str_replace_first('./img/sistemas-iconos/', './img/sistemas-iconos/descripcion/', str_replace_first('.svg','.jpg',$file)))); ?>">
				            	<img src="<?php echo e(asset(str_replace_first('./', '', $file))); ?>" />
			            	</a>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						
					</div>
				</div>
			</div>
		</div>
	</section>
    <section id="clientes" class="py-5">
    	<div class="container">
    		<div class="row">
    			<div class="col">
    				<h2 class="ralewal_bold text-uppercase text-center azul h3 mx-auto px-3"><span class="raleway_light">quienes han </span>confiado en nosotros</h2>
    				<hr>
    			</div>
    		</div>
    		<div class="row">
    			<div class="col py-3">
    				<div id="basicExample">
    					<?php
    						$dir = "./img/clientes/";
							// Abre un directorio conocido, y procede a leer el contenido
							if (is_dir($dir)) {
							    if ($dh = opendir($dir)) {
							        while (($file = readdir($dh)) !== false) { ?>
							            <a>
							            	<img alt="caption for image" src="<?php echo e(asset("img/clientes/$file")); ?>"/>
						            	</a>
							        <?php }
							        closedir($dh);
							    }
							} else {
								echo "no";
								echo $dir;
							}
    					?>
    				</div>
    			</div>
    		</div>
    	</div>
    </section>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- Modal -->
	<div class="modal fade" id="modal-imagen-alta" tabindex="-1" role="dialog" aria-labelledby="modal-imagen-altaLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header d-none">
					<h5 class="modal-title" id="modal-imagen-altaLabel">Modal title</h5>
				</div>
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<img src="" class="img-fluid mx-auto d-block lazy-load">
				</div>
				<div class="modal-footer d-none">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn btn-primary">Save changes</button>
				</div>
			</div>
		</div>
	</div>
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" class="d-none">
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-fluffy-linea-hogar-colchones-carreiro.png')); ?>" class="d-none">
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" class="d-none">
	<img src="<?php echo e(asset('/img/colchones/hotelero/abierto-tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" class="d-none">
	<!-- Modal -->
	<div class="modal fade" id="modal-video" tabindex="-1" role="dialog" aria-labelledby="modal-videoLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close" style="position: absolute;top: -5px;right: 0;">
						<span aria-hidden="true">&times;</span>
					</button>
					<div class="embed-responsive embed-responsive-16by9">
						<video class="embed-responsive-item" controls autoplay>
							Tu navegador no puede reproducir este video
						</video>
					</div>
				</div>
				
			</div>
		</div>
	</div>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js')); ?>"></script>
	
	<script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
	
	<script src="<?php echo e(asset('Justified-Gallery/js/jquery.justifiedGallery.min.js')); ?>"></script>
	<script src="<?php echo e(asset('colorbox-master/jquery.colorbox-min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/hotelero.js?v=30')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
</body>
</html>