<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo = "Línea Angelus | Colchones Carreiro";
		$descripcion = "Colchones para toda la familia. Colchón individual, matrimonal, king size, colchones a excelente precio, contamos con colchones económicos y colchones elaborados con tecnología de vanguardia para asegurarte el mejor descanso a ti y a tu familia. Puedes checar nuestros modelos de colchones  en esta sección."
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>Línea Angelus | Colchones Carreiro</title>
	<meta name="description" content="<?php echo e($descripcion); ?>" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="Línea Angelus | Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	
	<meta property="og:image" content="<?php echo e(asset('img/logos/angelous-proximamente.png')); ?>" />
	<meta property="og:description" content="<?php echo e($descripcion); ?>" />

	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/colchones.css')); ?>">

	<!-- LOADING FONTS AND ICONS -->
    <link href="http://fonts.googleapis.com/css?family=Raleway:400%7CLato:300%7CRoboto:500%7CBelleza:400" rel="stylesheet" property="stylesheet" type="text/css" media="all">


	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('revslider/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('revslider/fonts/font-awesome/css/font-awesome.css')); ?>">

	<!-- REVOLUTION STYLE SHEETS -->
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('revslider/css/settings.css')); ?>">
	<!-- REVOLUTION LAYERS STYLES -->
	<style type="text/css">	#rev_slider_1_1_wrapper .tp-loader.spinner3{ background-color: rgba(255, 255, 255, 0) !important; } </style>
</head>
<body>
	
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<section class="mt-5">
		
		<?php echo $__env->make('includes.angelous', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	</section>

	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/hogar.js')); ?>"></script>

    <!-- REVOLUTION JS FILES -->
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/jquery.themepunch.tools.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/jquery.themepunch.revolution.min.js')); ?>"></script>

    
    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.actions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.carousel.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.kenburn.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.migration.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.navigation.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.parallax.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('revslider/js/extensions/revolution.extension.video.min.js')); ?>"></script>

<script type="text/javascript">function setREVStartSize(e){                                    
			try{ e.c=jQuery(e.c);var i=jQuery(window).width(),t=9999,r=0,n=0,l=0,f=0,s=0,h=0;
				if(e.responsiveLevels&&(jQuery.each(e.responsiveLevels,function(e,f){f>i&&(t=r=f,l=e),i>f&&f>r&&(r=f,n=e)}),t>r&&(l=n)),f=e.gridheight[l]||e.gridheight[0]||e.gridheight,s=e.gridwidth[l]||e.gridwidth[0]||e.gridwidth,h=i/s,h=h>1?1:h,f=Math.round(h*f),"fullscreen"==e.sliderLayout){var u=(e.c.width(),jQuery(window).height());if(void 0!=e.fullScreenOffsetContainer){var c=e.fullScreenOffsetContainer.split(",");if (c) jQuery.each(c,function(e,i){u=jQuery(i).length>0?u-jQuery(i).outerHeight(!0):u}),e.fullScreenOffset.split("%").length>1&&void 0!=e.fullScreenOffset&&e.fullScreenOffset.length>0?u-=jQuery(window).height()*parseInt(e.fullScreenOffset,0)/100:void 0!=e.fullScreenOffset&&e.fullScreenOffset.length>0&&(u-=parseInt(e.fullScreenOffset,0))}f=u}else void 0!=e.minHeight&&f<e.minHeight&&(f=e.minHeight);e.c.closest(".rev_slider_wrapper").css({height:f})                    
			}catch(d){console.log("Failure at Presize of Slider:"+d)}                        
		};</script>


		<script type="text/javascript">
			            var revapi1,
			tpj;
(function() {
    if (!/loaded|interactive|complete/.test(document.readyState)) document.addEventListener("DOMContentLoaded",onLoad); else onLoad();

    function onLoad() {
        if (tpj===undefined) { tpj = jQuery; if("off" == "on") tpj.noConflict();}
				if(tpj("#rev_slider_1_1").revolution == undefined){
					revslider_showDoubleJqueryError("#rev_slider_1_1");
				}else{
					revapi1 = tpj("#rev_slider_1_1").show().revolution({
						sliderType:"standard",
jsFileLocation:"//revslider.test/revslider/public/assets/js/",
						sliderLayout:"fullscreen",
						dottedOverlay:"none",
						delay:9000,
						navigation: {
							onHoverStop:"off",
						},
						responsiveLevels:[1240,1240,1240,480],
						visibilityLevels:[1240,1240,1240,480],
						gridwidth:[1280,1280,1280,480],
						gridheight:[720,720,720,1200],
						lazyType:"none",
						shadow:0,
						spinner:"spinner3",
						stopLoop:"on",
						stopAfterLoops:0,
						stopAtSlide:1,
						shuffle:"off",
						autoHeight:"off",
						fullScreenAutoWidth:"off",
						fullScreenAlignForce:"off",
						fullScreenOffsetContainer: "",
						fullScreenOffset: "",
						disableProgressBar:"on",
						hideThumbsOnMobile:"off",
						hideSliderAtLimit:0,
						hideCaptionAtLimit:0,
						hideAllCaptionAtLilmit:0,
						debugMode:false,
						fallbacks: {
							simplifyAll:"off",
							nextSlideOnWindowFocus:"off",
							disableFocusListener:false,
						}
					});
    }; /* END OF revapi call */
     }; /* END OF ON LOAD FUNCTION */
}()); /* END OF WRAPPING FUNCTION */
		</script>
</body>
</html>