<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo ="CARREIRO";
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('animate-css/animate.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('aos-master/aos.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('owl-carousel/assets/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('owl-carousel/assets/owl.theme.default.min.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. <?php echo e($titulo); ?>® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/fondos/intro_angelita-2-colchones-carreiro.jpg')); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. <?php echo e($titulo); ?>® ¡Por tradición!" />

	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/index.css?v=31')); ?>">
	<?php
		use Jenssegers\Agent\Agent;
		$agent = new Agent();
	?>
	<?php if($agent->isIE()): ?>
		<link rel="stylesheet" href="<?php echo e(asset('css/ie.css')); ?>">
	<?php endif; ?>

	<style>
		#btn-cerrar-video {
			background-color: rgba(0,0,0,.41);
			border: 1px solid white;
			cursor:pointer;
			width: 255px;
			height: 65px;
			color: white;
			font-size: 20px;
		}
		#boton-con-manita {
			position: absolute;
			left: 50%;
			margin-left: calc(-255px / 2);
			bottom: 150px;
			display: none;
		}
		#boton-con-manita img {
			position: absolute;
			left: -25px;
			bottom: -25px;
			cursor: pointer;
		}
	</style>
</head>
<body>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php if(!((isset($_GET['m'])) || (isset($_GET['contactanos'])))): ?>
		<div class="index-video-wrapper">
			<video autoplay muted poster="<?php echo e(asset('img/fondos/intro_angelita-2-colchones-carreiro.jpg')); ?>" id="index-video">
				<?php if($agent->isMobile()): ?>
					<source src="<?php echo e(asset('video/intro_cel.mp4')); ?>" type="video/mp4">
				<?php else: ?>
					<source src="<?php echo e(asset('video/intro_web.mp4')); ?>" type="video/mp4">
				<?php endif; ?>
			</video>
			<div id="boton-con-manita">
				<button id="btn-cerrar-video" class="raleway_regular">ADÉNTRATE AL MUNDO<br>DEL <span class="naranja">DESCANSO</button>
				<img src="<?php echo e(asset('img/iconos/manita-colchones-carreiro.svg')); ?>" alt="Donde compro mi colchon" style="width:auto;height:50px;" class="animated infinite pulse">
			</div>
		</div>
	<?php endif; ?>
	<section id="panels" class="ajuste_menu">
		<div class="d-flex flex-row justify-content-center flex-wrap">
			<div class="animacion" <?php if($agent->isAndroidOS()): ?> style="min-height: calc(100vh - 122px);" <?php endif; ?>>
				<div class="text-center">
					<img src="<?php echo e(asset('img/logos/isologo-linea-hogar-colchones-carreiro.svg?v=1')); ?>" alt="Linea Hogar <?php echo e($titulo); ?>" height="65">
					<h6 class="azul raleway_regular mt-4 animacion">Nos aseguramos que tu día<br>a día sea grandioso,<br>Inicialo con un <span class="raleway_bold">gran descanso.</span></h6>
				</div>
				<?php if($agent->isMobile()): ?>
					<img src="<?php echo e(asset('img/fondos/linea-hogar-colchones-carreiro-mobil.jpg')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
				<?php else: ?>
					<img src="<?php echo e(asset('img/fondos/linea-hogar-colchones-carreiro-1.jpg?v=1')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
				<?php endif; ?>
				<img src="<?php echo e(asset('img/colchon-hogar.png?v=2')); ?>" alt="<?php echo e(config('app.name')); ?>" class="position-absolute">
			</div>
			<div class="animacion">
				<div class="text-center">
					<img src="<?php echo e(asset('img/logos/logo first class guest.svg?v=1')); ?>" alt="Line Hotelera <?php echo e($titulo); ?>" height="70">
					<h6 class="azul raleway_regular mt-4 animacion">Estamos dentro de las mejores<br>cadenas hoteleras alrededor del mundo,<br>compruebe porqué somos la mejor opción<br>y la del <span class="raleway_bold">descanso de sus huéspedes.</span></h6>
				</div>
				<img src="<?php echo e(asset('img/fondos/interior-hoteleria_FIRST.jpg?v=2')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
				<img src="<?php echo e(asset('img/colchon-guest.png')); ?>" alt="<?php echo e(config('app.name')); ?>" class="position-absolute">
			</div>
			<div class="animacion">
				<div class="text-center">
					<img src="<?php echo e(asset('img/logos/isologo-linea-medico-hospitalario-colchones-carreiro.svg?v=1')); ?>" alt="Colchon Clinico <?php echo e($titulo); ?>" height="70">
					<h6 class="azul raleway_regular mt-4 animacion">Sus pacientes necesitan<br><span class="raleway_bold">el mejor de los descansos</span>,<br>para una rápida recuperación.</h6>
				</div>
				<img src="<?php echo e(asset('img/fondos/linea-hospital-colchones-carreiro.jpg?v=2')); ?>" alt="Para que sus huéspedes sueñen con los angelitos <?php echo e($titulo); ?>" class="fondo_diagonal animacion">
				<img src="<?php echo e(asset('img/colchon-medico.png')); ?>" alt="<?php echo e(config('app.name')); ?>" class="position-absolute">
			</div>
		</div>
		<div id="scroll">
			<h6 class="raleway_medium blanco"><small>DESPLAZA HACIA ABAJO</small></h6>
			<a href="#doctora"><span></span></a>
		</div>
		<div class="degradado"></div>
	</section>
	<section id="doctora" class="py-5 py-sm-0">
		<div class="container-fluid">
			<div class="row align-items-center">
				<div class="col-12 col-md-5 pointer" data-aos="fade-right" style="cursor: pointer;">
					<p class="raleway_bold_italic azul h6">Mejora tu calidad de sueño y la de tus seres queridos,  visita mi blog y escucha mis podcast. Mi objetivo es orientarte para aumentar tu bienestar y el de tu familia.</p>
					<img src="<?php echo e(asset('img/comprar/doctora-descanso-colchones-carreiro.png?v=2')); ?>" alt="Doctora Descanso <?php echo e($titulo); ?>" class="fondo_doctora pointer">
				</div>
				<div class="col-12 col-sm-6 col-md-3 py-4">
					<h3 class="raleway_bold azul text-center">¿Dónde compro mi</h3>
					<div class="d-flex justify-content-center">
						<div <?php if($agent->isFirefox()): ?> style="width: 90%"; <?php endif; ?>>
							<img src="<?php echo e(asset('img/logos/imagotipo-azul-colchones-carreiro.svg?v=2')); ?>" alt="Imagotipo <?php echo e($titulo); ?>" class="img-fluid d-inline-block"><span class="d-inline-block raleway_bold azul" style="font-size: 2em;vertical-align: middle;line-height: 0; width: 10%;"> ?</span>
						</div>
					</div>
					<div>
						<a href="<?php echo e(url('/tiendas')); ?>">
							<img src="<?php echo e(asset('img/iconos/donde-compro-mi-colchon_.svg')); ?>" alt="donde compro <?php echo e($titulo); ?>" class="mx-auto img-fluid d-block pt-2 animated infinite pulse">
						</a>
						<a href="<?php echo e(url('/tiendas')); ?>">
							<img src="<?php echo e(asset('img/iconos/manita-colchones-carreiro.svg')); ?>" alt="donde compro <?php echo e($titulo); ?>" height="60">
						</a>
					</div>
				</div>
				<div class="col-12 col-sm-6 col-md-4 py-sm-4" data-aos="fade-left">
					<img src="<?php echo e(asset('img/comprar/localizar-colchon-carreiro.svg')); ?>" alt="Localizar <?php echo e($titulo); ?>" class="mx-auto d-block animated infinite pulse" height="30">
					<img src="<?php echo e(asset('img/comprar/amo-mi-colchon-carreiro.png?v=1')); ?>" alt="Amo mi <?php echo e($titulo); ?>" class="mx-auto img-fluid d-block">
				</div>
			</div>
		</div>
	</section>
	<section id="numeros">
		<div class="container-fluid">
			<div class="row">
				<div class="col-6 col-sm-3 text-center">
					<img src="<?php echo e(asset('img/iconos/puntos-de-venta-colchones-carreiro.svg')); ?>" alt="Puntos de Venta <?php echo e($titulo); ?>" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">PUNTOS DE VENTA</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='1100' data-delay='10' data-increment='10'>1100</span>
				</div>
				<div class="col-6 col-sm-3 text-center">
					<img src="<?php echo e(asset('img/iconos/hoteles-donde-estamos-colchones-carreiro.svg')); ?>" alt="Hoteles donde Estamos <?php echo e($titulo); ?>" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">HOTELES DONDE ESTAMOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='520' data-delay='10' data-increment='10'>520</span>
				</div>
				<div class="col-6 col-sm-3 text-center pt-3 pt-sm-0">
					<img src="<?php echo e(asset('img/iconos/paises-donde-estamos-colchones-carreiro.svg')); ?>" alt="Paises donde Estamos <?php echo e($titulo); ?>" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">REGIONES DONDE ESTAMOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='9' data-delay='1' data-increment='1'>9</span>
				</div>
				<div class="col-6 col-sm-3 text-center pt-3 pt-sm-0">
					<img src="<?php echo e(asset('img/iconos/clientes-satisfechos-colchones-carreiro.svg')); ?>" alt="Clientes Satisfechos <?php echo e($titulo); ?>" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">CLIENTES SATISFECHOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1000000' data-max='10520000' data-delay='1000' data-increment='10000'>10520000</span>
				</div>
			</div>
		</div>
	</section>
	<section id="testimonios" class="pb-3 pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col text-center mx-auto">
					<hr>
					<h3 class="raleway_light h5 blanco">OPINIONES DE <span class="raleway_bold">EXPERTOS</span></h3>
					<hr>
				</div>
			</div>
			<div class="row">
				<div class="col mt-2">
					<div class="owl-carousel owl-theme d-flex">
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>El tener un colchon Carreiro ha sido toda una experiencia de descanso maravillosa, lo recomiendo mucho y sí que descansas!</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/claudia-vazquez.jpg')); ?>" alt="Claudia Vazquez">
										</div>
										<p><strong class="blanco">Claudia Vazquez</strong></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Mi cama es el lugar donde duermo y paso mucho tiempo descansando. Me ayuda mucho para la columna tener un buen colchón. Encontré éste y es una bendición.  Antes no sabía lo que era dormir así.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Fabian-Terrones.jpg')); ?>" alt="Fabián Terrones">
										</div>
										<p><strong class="blanco">Fabián Terrones</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Las personas deben invertir en tener un buen colchón. Si no duermes bien, no vas a estar bien. Mi colchón es lo más rico que hay. Gracias <?php echo e($titulo); ?></p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Maria-Elena.jpg')); ?>" alt="María Elena Baños">
										</div>
										<p><strong class="blanco">María Elena Baños</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Duermo muy bien, lo recomiendo.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Gerardo-Juarez.jpg')); ?>" alt="Gerardo Juarez">
										</div>
										<p><strong class="blanco">Gerardo Juarez</strong></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Hace un año tuve una operación donde la mayor parte del día tenía que estar en cama, mi hijo me compró un colchón carreiro y fue una maravilla para mi recuperación, lo recomiendo ampliamente.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/norma-garcia.jpg')); ?>" alt="Norma García Castillo">
										</div>
										<p><strong class="blanco">Norma García Castillo</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Me gustan los <?php echo e($titulo); ?>, compré uno hace mucho tiempo y aún funciona muy bien.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Marlene-Munoz.jpg')); ?>" alt="Marlene Muñoz">
										</div>
										<p><strong class="blanco">Marlene Muñoz</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Sufría de dolor de espalda, iba al doctor y llegaron a la conclusión que el colchón que tenía no era el adecuado para mi, fui a una tienda en busca de un colchón que me sirviera para mi malestar y me recomendaron un Carreiro el modelo Freedom, solo puedo decir que duermo como bebé.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Karina-salinas.jpg')); ?>" alt="Karina Salinas">
										</div>
										<p><strong class="blanco">Karina Salinas</strong></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Había escuchado hablar mucho de la marca de <?php echo e($titulo); ?>, que uno descansaba muy bien en uno de ellos, así que decidí comprar uno y hoy en día no me arrepiento de haberlo hecho, simplemente si sueñas con los angelitos jajajajaja.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/luisito-Rey.jpg')); ?>" alt="Luisito Rey">
										</div>
										<p><strong class="blanco">Luisito Rey</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Yo tengo un colchón carreiro y duermo delicioso, como hace mucho no lo hacía, <?php echo e($titulo); ?>s la mejor opción. Descansas porque descansas.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Alfredo-sanchez.jpg')); ?>" alt="Alfredo Sánchez Navarro">
										</div>
										<p><strong class="blanco">Alfredo Sánchez Navarro</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>¡Yo no entiendo a las personas que tienen problemas para dormir! Tengo algunos años en mi Colchón Carreiro y de verdad, no hay un lugar más delicioso que mi cama. No importa cómo haya estado mi día; mi colchón es el mejor lugar para olvidar todo y sentirme apapachada. Descanso como nunca. Amo mi Carreiro.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Laura-Zamora.jpg')); ?>" alt="Laura Zamora">
										</div>
										<p><strong class="blanco">Laura Zamora</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Hace 3 años decidí comprar un Gran Duque y desde entonces mi espalda y yo hemos descansado como nunca. Ya no me gusta dormir fuera de casa porque ningún colchón es tan cómodo como mi Carreiro.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="<?php echo e(asset('img/testimonios/Victor-Rodriguez.jpg')); ?>" alt="Victor Rodriguez">
										</div>
										<p><strong class="blanco">Victor Rodriguez</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section id="sistemas" class="py-5">
		<div class="container-fluid">
			<div class="row">
				<div class="col text-center">
					<h4 class="raleway_extra_bold azul mb-5">NUESTROS SISTEMAS DE DESCANSO</h4>
				</div>
			</div>
			<div class="row">
				<div class="col-9 mx-auto">
					<div id="carousel" data-aos="fade-up">
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/multizone-technology-colchones-carreiro.png')); ?>" alt="Multizone Technology <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema de resortes con zonas independientes. </li>
										<li>Se adapta a las necesidades del cuerpo.</li>
										<li>Brinda confort y durabilidad.</li>
										<li>Descanso sin interrupciones.</li>
										<li>Sistema indeformable.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/hight-resistance-colchones-carreiro.png')); ?>" alt="Hight Resistance <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Fibras de poliuretano de alta recuperación.</li>
										<li>Posee mayor acojinamiento multicelular.</li>
										<li>Brinda mayor firmeza y comodidad.</li>
										<li>Capitonado especialmente diseñado para el descanso.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/up-turn-colchones-carreiro.png')); ?>" alt="Up Turn <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema con resortes y materiales de alta resistencia concentrados en una sola cara.</li>
										<li>Colchón 100% duradero.</li>
										<li>Sin necesidad de darle vuelta.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/comfort-tech-colchones-carreiro.png')); ?>" alt="Comfort Tech<?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema de resortes flexibles, que brinda una mejor adaptación al contorno del cuerpo.</li>
										<li>Provee un soporte óptimo para la columna vertebral, aumentando la sensación de confort durante el descanso.</li>
										<li>Gracias a la complexión del resorte, se eliminan los puntos de tensión y se aumenta la durabilidad del colchón.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/smart-fit-colchones-carreiro.png')); ?>" alt="Smart Fit <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Confort total.</li>
										<li>Sistema inteligente que alivia la presión acumulada.</li>
										<li>La espuma viscolástica se adapta 100% al cuerpo.</li>
										<li>Brinda a la espalda una correcta posición.</li>
										<li>Permite un sueño profundo y relajado.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/superior-foam-colchones-carreiro.png')); ?>" alt="Superior Foam <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Unidad de espumas de alta calidad que brindan una mayor firmeza en la columna vertebral.</li>
										<li>Fibras de poliuretano en diferentes densidades que permiten una alta recuperación y durabilidad en el colchón.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/soft-dream-colchones-carreiro.png')); ?>" alt="Soft Dream <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Fibras de poliuretano de alta recuperación.</li>
										<li>Posee mayor acojinamiento multicelular.</li>
										<li>Brinda mayor firmeza y comodidad.</li>
										<li>Capitonado especialmente diseñado para el descanso.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="<?php echo e(asset('img/sistemas/twist-colchones-carreiro.png')); ?>" alt="Twist <?php echo e($titulo); ?>" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema con resortes y materiales de alta resistencia concentrados en sus dos caras.</li>
										<li>Colchón 100% duradero.</li>
										<li>Colchón de doble vuelta para mayor durabilidad.</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section>
		<!-- LightWidget WIDGET --><script src="https://cdn.lightwidget.com/widgets/lightwidget.js"></script><iframe src="//lightwidget.com/widgets/b7785d40c9d55253a70935a8f69febaf.html" scrolling="no" allowtransparency="true" class="lightwidget-widget" style="width:100%;border:0;overflow:hidden;"></iframe>

	</section>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- Modal Temporal-->
	<div class="video-container">
		<div>
			<video controls <?php echo e($agent->isMobile() ? 'muted' : ''); ?>>
				<source src="<?php echo e(asset('video/expo.webm')); ?>" type="video/webm">
				<source src="<?php echo e(asset('video/expo.mp4')); ?>" type="video/mp4">
				<source src="<?php echo e(asset('video/expo.ogg')); ?>" type="video/ogg">
			</video>
		</div>
		<i class="text-white fa-3x far fa-times-circle"></i>
	</div>
	
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('numscroller/numscroller-1.0.js')); ?>"></script>
    
    <script src="<?php echo e(asset('aos-master/aos.js')); ?>"></script>
    
    <script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('owl-carousel/owl.carousel.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/index.js?v=2')); ?>"></script>
    <script>
    	var path = '<?php echo e(Request::root()); ?>';
    	// ocultar todo el body
    	var get = '<?php echo e(isset($_GET['m']) ? true : isset($_GET['contactanos']) ? true : false); ?>';
    	// mostar modal contacto
    	var contactanos = '<?php echo e(isset($_GET['contactanos'])); ?>';
    	$(document).ready(function(){
    	    $('#index-video').on('ended',function(){
    	    	$('#boton-con-manita').fadeIn('slow');
    	    });

    	    var audioElement = document.createElement('audio');
    	    audioElement.setAttribute('src', '<?php echo e(asset('audio/Jingle.mp3')); ?>');

    	    audioElement.addEventListener('ended', function() {
    	    	this.remove();
    	    }, false);

    	    $('#boton-con-manita').click(function(event) {
    	    	audioElement.play();
    	    	$('body > section').show();
    	    	$('#index-video').parent('.index-video-wrapper').fadeOut('slow', function() {
    	    		$(this).remove();
    	    		$('#carousel').slick();
    	    	});
    	    });
    	});
    </script>
</body>
</html>