<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::redirect('/linea/hogar/viscolastic', '/linea/hogar/gran-marques', 301);

Route::get('/', function () {
    return view('index');
})->name('index');

Route::get('/test', function () {
    $agent = new Jenssegers\Agent\Agent();
    return view('acordeon', ['agent' => $agent]);
});

Route::get('/angelus', function () {
    return view('angelous-test');
});

Route::get('/angelus-test', function () {
    return view('angelous-test');
});

Route::get('/tiendas', 'TiendasController')->name('tiendas');

Route::get('/quienes-somos', function () {
    return view('somos');
});

Route::get('/historia', function () {
    return view('historia');
});

Route::get('/contactanos', function () {
    return view('contacto');
});
Route::get('/contacto', function () {
    return view('contacto');
});

Route::get('/navegador', function () {
    return view('navegador');
});

Route::get('felices-fiestas', function () {
    return view('video');
});

Route::get('sistemas-de-descanso', function () {
    return view('sistemas');
});

Route::post('/mailable', 'MailController');

Route::get('/{colchon}', function ($colchon) {
	return view('liverpool', ['colchon' => $colchon]);
})->where('colchon', 'base-tarima|box-spring|cama-extra|dream-maker-twist|dream-maker-upturn|fluffy-multizone-twist|fluffy-multizone-upturn'
);

Route::get('/doctora-descanso', function () {
    // return view('doctora.index');
    return redirect('https://doctoradescanso.com');
});

Route::get('/doctora-descanso/podcast', function () {
    return view('doctora.podcast');
});

Route::get('/linea/hotelera', function () {
    return view('hotelero')->with([
        'linea' => 'hotelera',
        'titulo' => "Linea Hotelera | Colchones Carreiro",
        'descripcion' => "Fabricamos colchones para hoteles. Colchones para su hotel a precios muy accesibles. Colchones a la medida de las necesidades de su hotel, que harán que sus huéspedes regresen."
    ]);
})->name('hotelera');

Route::get('/linea/hotelera-dreams-pack', function () {
    return view('hotelero-dreams-pack')->with([
        'linea' => 'hotelera',
        'titulo' => "Linea Hotelera Dreams Pack | Colchones Carreiro",
        'descripcion' => "Fabricamos colchones para hoteles. Colchones para su hotel a precios muy accesibles. Colchones a la medida de las necesidades de su hotel, que harán que sus huéspedes regresen."
    ]);
})->name('hotelera');

Route::redirect('/linea/clinico', '/linea/medico', 301);

Route::get('/linea/medico', function () {
    return view('clinico')->with('linea','medico-hospitalario');
});

Route::redirect('/linea/hogar', '/linea/hogar/gran-marques', 301);

// Route::get('/linea/hogar', function () {
//     $agent = new Jenssegers\Agent\Agent();
//     return view('intro-hogar')->with('agent', $agent);
// });

Route::get('/linea/hogar/{slug}', 'SeleccionarColchonesHogar')->name('linea-hogar');
Route::get('/linea/hogar-dreams-pack/{slug}', 'SeleccionarColchonesHogarDreamsPack')->name('linea-hogar-dreams-pack');
// Route::get('/linea/angelous/{slug}', 'SeleccionarColchonesAngelous')->name('linea-angelous');

Route::get('/direccion/{estado}', 'DireccionController@estado')->name('direccion-estado');
Route::get('/direccion/{estado}/{delegacion}', 'DireccionController@delegacion')->name('direccion-delegacion');
