
@extends('layout')

@section('titulo', 'Tiendas')

@section('descripcion', 'Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!')

@section('imagen')
	{{ asset('img/redes-sociales/tienda.jpg') }}
@endsection

@section('css')
	<link rel="stylesheet" href="{{ asset('css/sucursales.css?v=5') }}">
@endsection

@section('contenido')
	<section style="margin-top: 100px;" id="app" class="pt-2 pb-5">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-sm text-center">
					<h1 class="h3 mb-0">Encuentra tu Carreiro en las tiendas de nuestros distribuidores autorizados.</h1>
					<h2 class="h6 mb-4" style="color:#3975a6;">*Si no tienen el modelo que buscas, solicítalo al momento.</h2>
				</div>
				<div class="col-sm-auto">
					<img src="{{ asset('img/logos/DISTRIBUIDOR OFICIAL.svg?v=1') }}" alt="Colchones Carreiro DISTRIBUIDOR OFICIAL" class="img-fluid mx-auto d-block" style="height: 125px;">
				</div>
			</div>
			<div class="row">
				<div class="{{ $ie ? 'd-none' : 'col-md-4' }}">
					<form>
						
						<div class="form-group">
							{{-- <label>¿Dónde me encuentro?:</label> --}}
							<select class="form-control" v-model="estado" @change="BuscarDelegaciones">
								<option value="donde"  disabled selected>¿Dónde me encuentro?</option>
								{{-- <option value="Aguascalientes">Aguascalientes</option> --}}
								{{-- <option value="Baja California">Baja California</option> --}}
								{{-- <option value="Baja California Sur">Baja California Sur</option> --}}
								{{-- <option value="Campeche">Campeche</option> --}}
								{{-- <option value="Coahuila">Coahuila</option> --}}
								<option value="Colima">Colima</option>
								{{-- <option value="Chiapas">Chiapas</option> --}}
								{{-- <option value="Chihuahua">Chihuahua</option> --}}
								<option value="Ciudad de México">CDMX</option>
								{{-- <option value="Durango">Durango</option> --}}
								<option value="Guanajuato">Guanajuato</option>
								{{-- <option value="Guerrero">Guerrero</option> --}}
								<option value="Hidalgo">Hidalgo</option>
								<option value="Jalisco">Jalisco</option>
								<option value="Estado de México">Estado de México</option>
								<option value="Michoacán de Ocampo">Michoacán</option>
								<option value="Morelos">Morelos</option>
								{{-- <option value="Nayarit">Nayarit</option> --}}
								{{-- <option value="Nuevo León">Nuevo León</option> --}}
								{{-- <option value="Oaxaca">Oaxaca</option> --}}
								<option value="Puebla">Puebla</option>
								<option value="Querétaro">Querétaro</option>
								<option value="Quintana Roo">Quintana Roo</option>
								{{-- <option value="San Luis Potosí">San Luis Potosí</option> --}}
								<option value="Sinaloa">Sinaloa</option>
								{{-- <option value="Sonora">Sonora</option> --}}
								{{-- <option value="Tabasco">Tabasco</option> --}}
								{{-- <option value="Tamaulipas">Tamaulipas</option> --}}
								<option value="Tlaxcala">Tlaxcala</option>
								{{-- <option value="Veracruz">Veracruz</option> --}}
								{{-- <option value="Yucatán">Yucatán</option> --}}
								<option value="Zacatecas">Zacatecas</option>
							</select>
						</div>
			
						<div class="form-group" v-if="estado">
							{{-- <label>Alcaldía o municipio</label> --}}
							<select class="form-control" v-model="delegacion" @change="BuscarDireccion">
								<option value="alcaldia" disabled selected>Alcaldía o municipio</option>
								<option :value="delegacion" v-for="delegacion in delegaciones">@{{ delegacion }}</option>
							</select>
						</div>
							
						
						
						{{-- <button type="submit" class="btn btn-primary">Buscar</button> --}}
					</form>

					@if ($ie)
						<div class="table-responsive" v-if="direcciones != null">
							<table class="table">
								<thead>
									<tr>
										<th>Tienda</th>
										<th>Estado</th>
										<th>Alcaldía / Municipio</th>
										<th>Dirección</th>
									</tr>
								  </thead>
								  <tbody>
								  	@foreach ($direcciones as $direccion)
								  		<tr>
								  			<td>{{ $direccion->tienda }}</td>
								  			<td>{{ $direccion->estado->nombre }}</td>
								  			<td>{{ $direccion->delegacion->nombre }}</td>
								  			<td>{{ $direccion->direccion }}</td>
								  		</tr>
								  	@endforeach
								  </tbody>
							</table>
						</div>
					@else
						<div class="table-responsive" v-if="direcciones != null">
							<table class="table">
								<thead>
									<tr>
										<th>Tienda</th>
										<th>Direccion</th>
									</tr>
								  </thead>
								  <tbody>
								  	<tr v-for="direccion in direcciones">
								  		<td>@{{ direccion.tienda }}</td>
								  		<td>@{{ direccion.direccion }}</td>
								  	</tr>
								  </tbody>
							</table>
						</div>
						<template v-if="direcciones != null">
							<div v-if="!direcciones.length" class="alert alert-danger" role="alert">Por el momento no tenemos una sucursal en esta ubicación</div>
						</template>
					@endif
				</div>
				<div class="{{ $ie ? 'col' : 'col-md-8' }} order-1 order-md-2">
					<div id="gmap" style="height: 500px;"></div>
				</div>
			</div>
		</div>
	</section>
@endsection

@section('js')
	{{-- Google Maps --}}
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCrNGRpU78bQ1hlGOrAZ3ynNdbWXZAYD44&callback=initMap"></script>
	<script type="text/javascript" src="{{ asset('maplace/maplace.min.js') }}"></script>
	<script src="{{ asset('js/sucursales.js?v=16') }}"></script>
	{{-- VUE.JS --}}
	<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
	<script src="https://unpkg.com/axios/dist/axios.min.js"></script>
	<script>
		new Vue({
			el: '#app',
			data: {
				estado: 'donde',
				delegacion: 'alcaldia',
				delegaciones: null,
				direcciones: null
			},
			methods: {
				BuscarDelegaciones: function (argument) {
					axios
						.get('{{ url('direccion') }}/'+this.estado)
						.then(response => (this.delegaciones = response.data))
				},
				BuscarDireccion: function (argument) {
					if (this.delegacion == 'N/D') {
						this.delegacion = 'N-D'
					}
					axios
						.get('{{ url('direccion') }}/'+this.estado+'/'+this.delegacion)
						.then(response => (this.direcciones = response.data))
				}
			}
		});
	</script>
@endsection