<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	@php
		$titulo = "Quienes Somos | Colchones Carreiro";
	@endphp
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('bootstrap-4/css/bootstrap.min.css') }}" >
   
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>{{ $titulo }}</title>
	<meta name="description" content="Brindar a nuestros clientes una satisfacción total en su descanso y confort, a través de una permanente innovación en los materiales que utilizamos y calidad total en cada uno de los colchones que fabricamos." />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="{{ $titulo }}" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	<meta property="og:image" content="{{ asset('img/redes-sociales/historia-colchones-careriro-2.jpg') }}" />
	<meta property="og:description" content="Brindar a nuestros clientes una satisfacción total en su descanso y confort, a través de una permanente innovación en los materiales que utilizamos y calidad total en cada uno de los colchones que fabricamos." />
	
	<link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css') }}">
	<link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/fonts/font-awesome/css/font-awesome.css') }}">    
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/settings.css') }}">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/layers.css') }}">
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/navigation.css') }}">

	{{-- CSS --}}
	<link rel="stylesheet" href="{{ asset('css/fuentes.css') }}">
	<link rel="stylesheet" href="{{ asset('css/globales.css?v=1') }}">
	<link rel="stylesheet" href="{{ asset('css/somos.css') }}">
</head>
<body>
	@include('includes.header')
	@php
		use Jenssegers\Agent\Agent;
		$agent = new Agent();
	@endphp
	@if ($agent->isMobile() || $agent->isTablet())
	<section id="mision-vision-mini" class="py-3">
		<div class="container">
			<div class="row mt-5">
				<div class="col-12 mt-5">
					<img src="{{ asset('img/quienes-somos/mision-vision-colchones-carreiro.jpg') }}" alt="Mision Vision {{ $titulo }}" class="img-fluid mx-auto d-block">
				</div>
				<div class="col-12">
					<h3 class="fondo_azul text-white raleway_regular mt-2 h4">MISIÓN</h3>
					<p class="raleway_regular">Brindar a nuestros clientes una satisfacción total en su descanso y confort, a través de una permanente innovación en los materiales que utilizamos y calidad total en cada uno de los colchones que fabricamos.</p>
				</div>
				<div class="col-12">
					<h3 class="fondo_azul text-white raleway_regular h4">VISIÓN</h3>
					<p class="raleway_regular">Ser la empresa líder en la industria de colchones en México, brindando a través de nuestros productos el mejor servicio y la mejor calidad en cada punto de la República Mexicana y/o el extranjero.</p>
				</div>
			</div>
		</div>
	</section>
	<section id="valores-mini" class="py-3">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<img src="{{ asset('img/quienes-somos/fabrica-colchones-carreiro.jpg') }}" alt="Colchon Clínico {{ $titulo }}" class="img-fluid d-block mx-auto">
				</div>
				<div class="col-12 mt-2">
					<h3 class="fondo_azul text-white raleway_regular h4">VALORES</h3>
					<p class="raleway_regular">Capacitamos a nuestro personal con altos valores como la honestidad, respeto y confianza, para servir correctamente a nuestros clientes.</p>
					<h4 class="raleway_bold">CALIDAD</h4>
					<p class="raleway_regular">Contamos con avanzados procesos de producción, control de calidad e higiene para garantizar que nuestros productos estén siempre a la vanguardia.</p>
					<h4 class="raleway_bold">CLIENTES</h4>
					<p class="raleway_regular">Permanentemente nos ocupamos en evaluar la satisfacción de nuestros clientes, para que los estándares de calidad que brindamos, sean siempre los óptimos.</p>
				</div>
				<div class="col-12">
					<img src="{{ asset('img/quienes-somos/mapa-colchones-carreiro.png') }}" alt="Colchon Clínico {{ $titulo }}" class="mx-auto d-block img-fluid">
				</div>
				<div class="col-12">
					<h3 class="fondo_azul text-white raleway_regular h4">COBERTURA</h3>
					<p class="raleway_regular">Colchones Carreiro®, cuenta con una de las plantas automatizadas más modernas de Latinoamérica, produciendo una media de 1100 colchones por jornada laboral, con puntos de venta en diferentes estados de la República Mexicana, así como presencia en otros países como Estados Unidos, Jamaica, República Dominicana, Guatemala, Panamá, Portugal y Cuba.  Con una delegación de oficinas corporativas en República Dominicana (Punta Cana) para atender el mercado de El Caribe.</p>
				</div>
			</div>
		</div>
	</section>
	@else
	<section class="ajuste_menu">
		<div class="rev_slider_wrapper fullscreen-container">
		 
		    <!-- the ID here will be used in the inline JavaScript below to initialize the slider -->
		    <div id="rev_slider_1" class="rev_slider fullscreenbanner tp-overflow-hidden" data-version="5.4.7.2" style="display:none">
		 
		        <ul>
		            

				    {{-- SLIUDE 2 --}}
				    <li data-transition="scaledownfrombottom">
				    	<!-- SLIDE'S MAIN BACKGROUND IMAGE -->
				        <img src="{{ asset('img/fondos/mision-vision-colchones-carreiro.jpg') }}" alt="Mision Vision {{ $titulo }}" class="rev-slidebg" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="5">

				        <!-- LAYER  1 TEXT-->
						<div class="tp-caption tp-resizeme azul" 
						 
						    data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:left;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						 
						     data-x="['left','left','center','center']" 
						     data-y="center" 
						     data-hoffset="['0','0','0','0']" 
						     data-voffset="['70',70','0','0']" 
						     data-width="['500','500','90%','90%']"
						     data-height="['auto']"

						     data-whitespace="['normal']"
						     data-lineheight="'25', '20', '22', '30']"
						     data-fontsize="['16', '20', '22', '30']"

						      data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						>
							<div class="raleway_regular fondo_azul blanco py-2 px-4 d-inline-block mb-2" style="font-size: 1.5em;">MISIÓN</div>
							<div class="raleway_regular">Brindar a nuestros clientes una satisfacción total en su descanso y confort, a través de una permanente innovación en los materiales que utilizamos y calidad total en cada uno de los colchones que fabricamos.</div>
						</div>

						<!-- LAYER  2 TEXT-->
						<div class="tp-caption tp-resizeme azul" 
						 
						    data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:left;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						 
						     data-x="['center','left','center','center']" 
						     data-y="bottom" 
						     data-hoffset="['-200','0','0','0']" 
						     data-voffset="['0','0','50','50']" 
						     data-width="['500','500','90%','90%']"
						     data-height="['auto']"

						     data-whitespace="['normal']"
						     data-lineheight="'25', '20', '22', '30']"
						     data-fontsize="['16', '20', '22', '30']"
						     data-textAlign="['right', 'right', 'left', 'left']"

						     data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						>
							<div class="raleway_regular fondo_azul blanco py-2 px-4 d-inline-block mb-2" style="font-size: 1.5em;">VISIÓN</div>
							<div class="raleway_regular">Ser la empresa líder en la industria de colchones en México, brindando a través de nuestros productos el mejor servicio y la mejor calidad en cada punto de la República Mexicana y/o el extranjero.</div>
						</div>

						<!-- LAYER 3 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":0,"speed":2000,"frame":"0","from":"x:right;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						 
						     data-type="image" 
						     data-x="['left','left','center','center']" 
						     data-y="top" 
						     data-hoffset="['0','0','0','0']" 
						     data-voffset="['0','0','50','50']" 
						     data-width="['auto']"
						     data-height="['auto']"

						      data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						><img src="{{ asset('img/quienes-somos/mision-vision-colchones-carreiro.jpg') }}" alt="Colchon Clínico {{ $titulo }}" data-ww="['auto']" data-hh="['250px']" class="rounded-bottom rounded-top"></div>


				    </li>

				    <!-- SLIDE 1 -->
				    <li data-transition="scaledownfrombottom">
				 
				        <!-- SLIDE'S MAIN BACKGROUND IMAGE -->
				        <img src="{{ asset('img/fondos/quines-somos-colchones-carreiro.jpg') }}" alt="{{ $titulo }}" class="rev-slidebg" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="5">

				        <!-- LAYER  1 TEXT-->
						<div class="tp-caption tp-resizeme azul" 
						 
						    data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:left;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						 
						     data-x="['left','left','center','center']" 
						     data-y="top" 
						     data-hoffset="['0','0','0','0']" 
						     data-voffset="['0','0','20','20']" 
						     data-width="['500','500','90%','90%']"
						     data-height="['auto']"

						     data-whitespace="['normal']"
						     data-lineheight="'23', '25', '22', '30']"
						     data-fontsize="['15', '15', '22', '30']"

						      data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						>
							<div class="raleway_regular fondo_azul blanco py-2 px-4 d-inline-block mb-2" style="font-size: 1.5em;">VALORES</div>
							<div class="raleway_bold">Capacitamos a nuestro personal con altos valores como la honestidad, respeto y confianza, para servir correctamente a nuestros clientes.</div>
							<br>
							<div class="raleway_bold">CALIDAD</div>
							<div class="raleway_regular">Contamos con avanzados procesos de producción, control de calidad e higiene para garantizar que nuestros productos estén siempre a la vanguardia.</div>
							<br>
							<div class="raleway_bold">CLIENTES</div>
							<div class="raleway_regular">Permanentemente nos ocupamos en evaluar la satisfacción de nuestros clientes, para que los estándares de calidad que brindamos, sean siempre los óptimos.</div>
						</div>

				        <!-- LAYER 2 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":0,"speed":2000,"frame":"0","from":"x:right;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						 
						     data-type="image" 
						     data-x="['left','left','center','center']" 
						     data-y="bottom" 
						     data-hoffset="['200','0','0','0']" 
						     data-voffset="['0','0','0','0']" 
						     data-width="['auto']"
						     data-height="['auto']"

						      data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						><img src="{{ asset('img/quienes-somos/mapa-colchones-carreiro.png') }}" alt="Colchon Clínico {{ $titulo }}" data-ww="['400px','400px','400px','400px']" data-hh="['auto']"></div>

						<!-- LAYER  3 TEXT-->
						<div class="tp-caption tp-resizeme azul" 
						 
						    data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:left;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						 
						     data-x="['right','right','center','center']" 
						     data-y="bottom" 
						     data-hoffset="['0','0','0','0']" 
						     data-voffset="['0','0','150','80']" 
						     data-width="['500','500','90%','90%']"
						     data-height="['auto']"

						     data-whitespace="['normal']"
						     data-lineheight="'23', '23', '22', '30']"
						     data-fontsize="['15', '15', '22', '30']"
						     data-textAlign="['right', 'right', 'left', 'left']"

						     data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						>
							<div class="raleway_regular fondo_azul blanco py-2 px-4 d-inline-block mb-2" style="font-size: 1.5em;">COBERTURA</div>
							<div class="raleway_regular">Colchones Carreiro®, cuenta con una de las plantas automatizadas más modernas de Latinoamérica, produciendo una media de 1100 colchones por jornada laboral, con puntos de venta en diferentes estados de la República Mexicana, así como presencia en otros países como Estados Unidos, Jamaica, República Dominicana, Guatemala, Panamá, Portugal y Cuba.  Con una delegación de oficinas corporativas en República Dominicana (Punta Cana) para atender el mercado de El Caribe.</div>
						</div>

						<!-- LAYER 3 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":0,"speed":2000,"frame":"0","from":"x:right;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						 
						     data-type="image" 
						     data-x="['right','right','center','center']" 
						     data-y="top" 
						     data-hoffset="['0','0','0','0']" 
						     data-voffset="['0','0','250','200']" 
						     data-width="['auto']"
						     data-height="['auto']"

						      data-paddingright="[15]"
						     data-paddingleft="[15]"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						><img src="{{ asset('img/quienes-somos/fabrica-colchones-carreiro.jpg') }}" alt="Colchon Clínico {{ $titulo }}" data-ww="['auto']" data-hh="['300px']" class="rounded-bottom rounded-top"></div>

				    </li>
		        </ul>
		 
		    </div>
		 
		</div>
	</section>
	@endif
	@include('includes.footer')
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('popper/popper.min.js') }}"></script>
    <script src="{{ asset('bootstrap-4/js/bootstrap.min.js') }}"></script>
    {{-- Font Awesome --}}
    <script src="{{ asset('font-awesome-5.0.8/all.js') }}"></script>
    

     @if (!$agent->isMobile() || !$agent->isTablet())
     <!-- REVOLUTION JS FILES -->
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/jquery.themepunch.tools.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/jquery.themepunch.revolution.min.js') }}"></script>

    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->    
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.actions.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.carousel.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.kenburn.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.migration.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.navigation.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.parallax.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.slideanims.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.video.min.js') }}"></script>

    {{-- JS --}}
    <script src="{{ asset('js/globales.js') }}"></script>
    <script src="{{ asset('js/somos.js') }}"></script>
    <script>var path = '{{ Request::root() }}';</script>
    <script type="text/javascript">

	    /* https://learn.jquery.com/using-jquery-core/document-ready/ */
	    jQuery(document).ready(function() {
	    	$('#footer').hide();
	 
	        /* initialize the slider based on the Slider's ID attribute */
	        var carousel = jQuery('#rev_slider_1').show().revolution({
	 
	            /* options are 'auto', 'fullwidth' or 'fullscreen' */
	            sliderLayout: 'fullscreen',

				/* OFFSET SLIDER BY THE HEIGHT OF AN ELEMENT */
				fullScreenOffsetContainer: "nav",

				/* RESPECT ASPECT RATIO */
				autoHeight: 'off',

				/* MIN-HEIGHT */
				minHeight: '500',

				responsiveLevels: [1199, 991, 767, 575],
				gridwidth:[1140, 960, 720, 540],
				gridheight:[550, 650, 1200, 1500],

				/* [DESKTOP, LAPTOP, TABLET, SMARTPHONE] */
				// visibilityLevels:[1199, 991, 767, 575],

				/* PRELOADER OPTION "3" */
				spinner: 'spinner3',

				parallax: {
			        type: 'mouse+scroll',
			        origo: 'slidercenter',
			        speed: 400,
			        levels: [5,10,15,20,25,30,35,40,
			                 45,46,47,48,49,50,51,55],
			        disable_onmobile: 'on'
			    },
	 
	            /* basic navigation arrows and bullets */
	            navigation: {

	            	keyboardNavigation: 'on',
				    keyboard_direction: 'vertical',
				    mouseScrollNavigation: 'on',
				    mouseScrollReverse: 'normal',
				    onHoverStop: 'on',
	 
	                arrows: {
	                    enable: false,
	                    style: 'hesperiden',
	                    hide_onleave: false
	                },
	 
	                bullets: {
	                    enable: true,
	                    style: 'hephaistos',
	                    direction: 'vertical',
	                    h_align: 'right',
	                    v_align: 'center',
	                    space: 5,
 
        hide_onleave: false,
        hide_onmobile: false
	                }
	            }
	        });

			carousel.on('revolution.slide.onafterswap', function (event, data) {
 
			    var currentSlide = carousel.revcurrentslide();
			    console.log(currentSlide + " -- Cargo");
			    
			    if (currentSlide == 2) {
			    	$('#footer').fadeIn();
			    	AOS.refresh();
			    } else {
			    	$('#footer').hide();
			    }
			 
			});
	    });
	 
	</script>
	@endif
</body>
</html>