<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	@php
		$titulo ="CARREIRO";
	@endphp
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('bootstrap-4/css/bootstrap.min.css') }}?v=1" >
    {{-- Animate CSS --}}
    <link rel="stylesheet" href="{{ asset('animate-css/animate.css') }}">
    {{-- AOS Scroll --}}
    <link rel="stylesheet" href="{{ asset('aos-master/aos.css') }}">
    {{-- SLICK Carousel --}}
    <link rel="stylesheet" href="{{ asset('slick-1.8.0/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('slick-1.8.0/slick-theme.css') }}">
    {{-- OWL CAROUSEL --}}
    <link rel="stylesheet" href="{{ asset('owl-carousel/assets/owl.carousel.min.css') }}">
    <link rel="stylesheet" href="{{ asset('owl-carousel/assets/owl.theme.default.min.css') }}">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>{{ $titulo }}</title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. {{ $titulo }}® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="{{ $titulo }}" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	<meta property="og:image" content="{{ asset('img/fondos/intro_angelita-2-colchones-carreiro.jpg') }}" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. {{ $titulo }}® ¡Por tradición!" />

	{{-- CSS --}}
	<link rel="stylesheet" href="{{ asset('css/fuentes.css') }}">
	<link rel="stylesheet" href="{{ asset('css/globales.css?v=1') }}">
	<link rel="stylesheet" href="{{ asset('css/index.css?v=31') }}">

	<link rel="stylesheet" href="{{ asset('css/acordeon.css?v=13') }}">
	<link rel="stylesheet" href="{{ asset('css/unleash.3.css') }}">
	@php
		use Jenssegers\Agent\Agent;
		$agent = new Agent();
	@endphp
	@if ($agent->isIE())
		<link rel="stylesheet" href="{{ asset('css/ie.css') }}">
	@endif

	<style>
		#btn-cerrar-video {
			background-color: rgba(0,0,0,.41);
			border: 1px solid white;
			cursor:pointer;
			width: 255px;
			height: 65px;
			color: white;
			font-size: 20px;
		}
		#boton-con-manita {
			position: absolute;
			left: 50%;
			margin-left: calc(-255px / 2);
			bottom: 150px;
			display: none;
		}
		#boton-con-manita img {
			position: absolute;
			left: -25px;
			bottom: -25px;
			cursor: pointer;
		}
		#btn-saltar {
			right: 50px;
			bottom: 50px;
			border-radius: 30px;
		}
	</style>
</head>
<body>
	@include('includes.header')
	@if (!((isset($_GET['m'])) || (isset($_GET['contactanos']))))
		<div class="index-video-wrapper">
			<video autoplay muted id="index-video">
                <source src="{{ asset('video/fondo_web.mp4?v=1') }}" type="video/mp4">
				{{-- @if ($agent->isMobile())
					<source src="{{ asset('video/fondo_cel.mp4?v=1') }}" type="video/mp4">
				@else
				@endif --}}
			</video>
			<div id="boton-con-manita">
				<button id="btn-cerrar-video" class="raleway_regular">ADÉNTRATE AL MUNDO<br>DEL <span class="naranja">DESCANSO</button>
				<img src="{{ asset('img/iconos/manita-colchones-carreiro.svg') }}" alt="Donde compro mi colchon" style="width:auto;height:50px;" class="animated infinite pulse">
			</div>
			<button class="position-absolute btn btn-outline-light" id="btn-saltar" onclick="saltar_intro()">Saltar intro <i class="fas fa-chevron-right"></i></button>
		</div>
	@endif
	
	@if ($agent->isMobile())
		
		<section class="ajuste_menu" id="acordeon_mobil">
			<div class="container">
				<div class="row">
					<div class="col angelus">
						<a href="{{ url('/angelus') }}" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/acordeon/logos/angelus_logo.png?v=1') }}" class="img-fluid mx-auto d-block" style="height: 70px;">
						</a>
					</div>
				</div>
				<div class="row">
					<div class="col hogar">
						<a href="{{ url('/linea/hogar/gran-marques') }}" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('/img/logos/isologo-linea-hogar-colchones-carreiro.svg') }}" class="img-fluid mx-auto d-block" style="height: 60px;">
						</a>
					</div>
				</div>
				<div class="row">
					<div class="col fcg">
						<a href="{{ url('/linea/hotelera') }}" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/logos/logo_FCG.svg') }}" class="img-fluid mx-auto d-block" style="height: 60px;">
						</a>
					</div>
				</div>
				<div class="row">
					<div class="col medico">
						<a href="{{ url('/linea/clinico') }}" class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/logos/isologo-linea-medico-hospitalario-colchones-carreiro.svg') }}" class="img-fluid mx-auto d-block" style="height: 70px;">
						</a>
					</div>
				</div>
			</div>
		</section>

	@else
		
		<section class="ajuste_menu">
			<div class="unleash_container" id="acordion"> <!-- container -->
			    <div class="any_other_class unleash_slider"> <!-- slider -->

			        <div class="unleash_slide" onclick="window.location.href = '{{ url('/angelus') }}'"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/angelus.webp?v=5') }}">
			                <source src="{{ asset('video/acordeon/angelus.mp4?v=4') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/angelus.webp?v=5') }}" class="h-100" alt="Recubrimientos industriales{{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/angelus.svg') }}" class="mb-4">
			                <p class="text-white">Con la experiencia ganada desde el año 1970, elaboramos cuidadosamente a mano… Angelus, conjugando las más finas materias primas y los mejores sistemas de descanso, para conseguir que sueñes en “El lugar más tranquilo del mundo®”.</p>
			                <div class="text-verde-fuerte text-right">
			                    <a href="{{ url('/angelus') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-verde-fuerte">Sorpréndete</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide" onclick="window.location.href = '{{ url('/linea/hogar/gran-marques') }}'"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/hogar.webp?v=5') }}">
			                <source src="{{ asset('video/acordeon/hogar.mp4?v=2') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/hogar.webp?v=5') }}" class="h-100" alt="Investigación y desarrollo {{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/hogar.svg') }}" class="mb-4">
			                <p class="text-white">Inicia tu día con un gran descanso y descubre porqué somos el colchón consentido de todo México. 50 años fabricando noches placenteras para días grandiosos.</p>
			                <div class="text-morado text-right">
			                    <a href="{{ url('/linea/hogar/gran-marques') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-morado">Conócenos</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide" onclick="window.location.href = '{{ url('/linea/hotelera') }}'"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/fcg.webp?v=4') }}">
			                <source src="{{ asset('video/acordeon/FCG.mp4?v=3') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/fcg.webp?v=4') }}" class="h-100" alt="Recubrimientos arquitectónicos {{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/FCG.svg') }}" class="mb-4">
			                <p class="text-vwhite">Nuestro colchón de línea hotelera es insuperable, fabricados con la más alta calidad en materias primas y sistemas de descanso, satisfacemos los requerimientos más exigentes de nuestros clientes hoteleros, garantizando la satisfacción total de sus huéspedes; calidad que nos ubica dentro de las mejores cadenas hoteleras alrededor del mundo.</p>
			               	<div class="text-verde-claro text-right">
			                    <a href="{{ url('/linea/hotelera') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-verde-claro">Descúbralo</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			               	</div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide" onclick="window.location.href = '{{ url('/linea/clinico') }}'"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/medico.jpg?v=2') }}">
			                <source src="{{ asset('video/acordeon/medico.mp4?v=2') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/medico.jpg?v=2') }}" class="h-100" alt="Servicio integral {{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/medico.svg') }}" class="mb-4">
			                <p class="text-white">Es primordial la comodidad y el descanso que sus pacientes necesitan para una rápida recuperación; nuestro colchón Médico Hospitalario es perfecto para esa tarea, ya que está fabricado con espumas de alta calidad que brindan una grata sensación de comodidad a sus pacientes.</p>
			                <div class="text-amarillo text-right">
			                    <a href="{{ url('/linea/clinico') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-amarillo">Confíe</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			    </div> <!-- end slider -->
			</div> <!-- end container -->
		</section>

	@endif

	{{-- <section id="doctora" class="py-5 py-sm-0">
		<div class="container-fluid">
			<div class="row align-items-center">
				<div class="col-12 col-md-5 pointer" data-aos="fade-right" style="cursor: pointer;">
					<p class="raleway_bold_italic azul h6">Mejora tu calidad de sueño y la de tus seres queridos,  visita mi blog y escucha mis podcast. Mi objetivo es orientarte para aumentar tu bienestar y el de tu familia.</p>
					<img src="{{ asset('img/comprar/doctora-descanso-colchones-carreiro.png?v=2') }}" alt="Doctora Descanso {{ $titulo }}" class="fondo_doctora pointer">
				</div>
				<div class="col-12 col-sm-6 col-md-3 py-4">
					<h3 class="raleway_bold azul text-center">¿Dónde compro mi</h3>
					<div class="d-flex justify-content-center">
						<div @if ($agent->isFirefox()) style="width: 90%"; @endif>
							<img src="{{ asset('img/logos/imagotipo-azul-colchones-carreiro.svg?v=2') }}" alt="Imagotipo {{ $titulo }}" class="img-fluid d-inline-block"><span class="d-inline-block raleway_bold azul" style="font-size: 2em;vertical-align: middle;line-height: 0; width: 10%;"> ?</span>
						</div>
					</div>
					<div>
						<a href="{{ url('/tiendas') }}">
							<img src="{{ asset('img/iconos/donde-compro-mi-colchon_.svg') }}" alt="donde compro {{ $titulo }}" class="mx-auto img-fluid d-block pt-2 animated infinite pulse">
						</a>
						<a href="{{ url('/tiendas') }}">
							<img src="{{ asset('img/iconos/manita-colchones-carreiro.svg') }}" alt="donde compro {{ $titulo }}" height="60">
						</a>
					</div>
				</div>
				<div class="col-12 col-sm-6 col-md-4 py-sm-4" data-aos="fade-left">
					<img src="{{ asset('img/comprar/localizar-colchon-carreiro.svg') }}" alt="Localizar {{ $titulo }}" class="mx-auto d-block animated infinite pulse" height="30">
					<img src="{{ asset('img/comprar/amo-mi-colchon-carreiro.png?v=1') }}" alt="Amo mi {{ $titulo }}" class="mx-auto img-fluid d-block">
				</div>
			</div>
		</div>
	</section>
	<section id="numeros">
		<div class="container-fluid">
			<div class="row">
				<div class="col-6 col-sm-3 text-center">
					<img src="{{ asset('img/iconos/puntos-de-venta-colchones-carreiro.svg') }}" alt="Puntos de Venta {{ $titulo }}" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">PUNTOS DE VENTA</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='1100' data-delay='10' data-increment='10'>1100</span>
				</div>
				<div class="col-6 col-sm-3 text-center">
					<img src="{{ asset('img/iconos/hoteles-donde-estamos-colchones-carreiro.svg') }}" alt="Hoteles donde Estamos {{ $titulo }}" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">HOTELES DONDE ESTAMOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='520' data-delay='10' data-increment='10'>520</span>
				</div>
				<div class="col-6 col-sm-3 text-center pt-3 pt-sm-0">
					<img src="{{ asset('img/iconos/paises-donde-estamos-colchones-carreiro.svg') }}" alt="Paises donde Estamos {{ $titulo }}" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">REGIONES DONDE ESTAMOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1' data-max='9' data-delay='1' data-increment='1'>9</span>
				</div>
				<div class="col-6 col-sm-3 text-center pt-3 pt-sm-0">
					<img src="{{ asset('img/iconos/clientes-satisfechos-colchones-carreiro.svg') }}" alt="Clientes Satisfechos {{ $titulo }}" class="mx-auto d-block img-fluid">
					<h6 class="raleway_bold blanco mb-0 mt-3">CLIENTES SATISFECHOS</h6>
					<span class='numscroller naranja raleway_bold' data-min='1000000' data-max='10520000' data-delay='1000' data-increment='10000'>10520000</span>
				</div>
			</div>
		</div>
	</section>
	<section id="testimonios" class="pb-3 pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col text-center mx-auto">
					<hr>
					<h3 class="raleway_light h5 blanco">OPINIONES DE <span class="raleway_bold">EXPERTOS</span></h3>
					<hr>
				</div>
			</div>
			<div class="row">
				<div class="col mt-2">
					<div class="owl-carousel owl-theme d-flex">
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>El tener un colchon Carreiro ha sido toda una experiencia de descanso maravillosa, lo recomiendo mucho y sí que descansas!</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/claudia-vazquez.jpg') }}" alt="Claudia Vazquez">
										</div>
										<p><strong class="blanco">Claudia Vazquez</strong></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Mi cama es el lugar donde duermo y paso mucho tiempo descansando. Me ayuda mucho para la columna tener un buen colchón. Encontré éste y es una bendición.  Antes no sabía lo que era dormir así.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Fabian-Terrones.jpg') }}" alt="Fabián Terrones">
										</div>
										<p><strong class="blanco">Fabián Terrones</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Las personas deben invertir en tener un buen colchón. Si no duermes bien, no vas a estar bien. Mi colchón es lo más rico que hay. Gracias {{ $titulo }}</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Maria-Elena.jpg') }}" alt="María Elena Baños">
										</div>
										<p><strong class="blanco">María Elena Baños</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Duermo muy bien, lo recomiendo.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Gerardo-Juarez.jpg') }}" alt="Gerardo Juarez">
										</div>
										<p><strong class="blanco">Gerardo Juarez</strong></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Hace un año tuve una operación donde la mayor parte del día tenía que estar en cama, mi hijo me compró un colchón carreiro y fue una maravilla para mi recuperación, lo recomiendo ampliamente.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/norma-garcia.jpg') }}" alt="Norma García Castillo">
										</div>
										<p><strong class="blanco">Norma García Castillo</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Me gustan los {{ $titulo }}, compré uno hace mucho tiempo y aún funciona muy bien.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Marlene-Munoz.jpg') }}" alt="Marlene Muñoz">
										</div>
										<p><strong class="blanco">Marlene Muñoz</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Sufría de dolor de espalda, iba al doctor y llegaron a la conclusión que el colchón que tenía no era el adecuado para mi, fui a una tienda en busca de un colchón que me sirviera para mi malestar y me recomendaron un Carreiro el modelo Freedom, solo puedo decir que duermo como bebé.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Karina-salinas.jpg') }}" alt="Karina Salinas">
										</div>
										<p><strong class="blanco">Karina Salinas</strong></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Había escuchado hablar mucho de la marca de {{ $titulo }}, que uno descansaba muy bien en uno de ellos, así que decidí comprar uno y hoy en día no me arrepiento de haberlo hecho, simplemente si sueñas con los angelitos jajajajaja.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/luisito-Rey.jpg') }}" alt="Luisito Rey">
										</div>
										<p><strong class="blanco">Luisito Rey</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Yo tengo un colchón carreiro y duermo delicioso, como hace mucho no lo hacía, {{ $titulo }}s la mejor opción. Descansas porque descansas.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Alfredo-sanchez.jpg') }}" alt="Alfredo Sánchez Navarro">
										</div>
										<p><strong class="blanco">Alfredo Sánchez Navarro</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>¡Yo no entiendo a las personas que tienen problemas para dormir! Tengo algunos años en mi Colchón Carreiro y de verdad, no hay un lugar más delicioso que mi cama. No importa cómo haya estado mi día; mi colchón es el mejor lugar para olvidar todo y sentirme apapachada. Descanso como nunca. Amo mi Carreiro.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Laura-Zamora.jpg') }}" alt="Laura Zamora">
										</div>
										<p><strong class="blanco">Laura Zamora</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div class="col">
								<div class="testimonial testimonial-primary">
									<blockquote>
										<p>Hace 3 años decidí comprar un Gran Duque y desde entonces mi espalda y yo hemos descansado como nunca. Ya no me gusta dormir fuera de casa porque ningún colchón es tan cómodo como mi Carreiro.</p>
									</blockquote>
									<div class="testimonial-arrow-down"></div>
									<div class="testimonial-author">
										<div class="testimonial-author-thumbnail img-thumbnail">
											<img src="{{ asset('img/testimonios/Victor-Rodriguez.jpg') }}" alt="Victor Rodriguez">
										</div>
										<p><strong class="blanco">Victor Rodriguez</strong><span></span></p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section id="sistemas" class="py-5">
		<div class="container-fluid">
			<div class="row">
				<div class="col text-center">
					<h4 class="raleway_extra_bold azul mb-5">NUESTROS SISTEMAS DE DESCANSO</h4>
				</div>
			</div>
			<div class="row">
				<div class="col-9 mx-auto">
					<div id="carousel" data-aos="fade-up">
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/multizone-technology-colchones-carreiro.png') }}" alt="Multizone Technology {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema de resortes con zonas independientes. </li>
										<li>Se adapta a las necesidades del cuerpo.</li>
										<li>Brinda confort y durabilidad.</li>
										<li>Descanso sin interrupciones.</li>
										<li>Sistema indeformable.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/hight-resistance-colchones-carreiro.png') }}" alt="Hight Resistance {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Fibras de poliuretano de alta recuperación.</li>
										<li>Posee mayor acojinamiento multicelular.</li>
										<li>Brinda mayor firmeza y comodidad.</li>
										<li>Capitonado especialmente diseñado para el descanso.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/up-turn-colchones-carreiro.png') }}" alt="Up Turn {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema con resortes y materiales de alta resistencia concentrados en una sola cara.</li>
										<li>Colchón 100% duradero.</li>
										<li>Sin necesidad de darle vuelta.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/comfort-tech-colchones-carreiro.png') }}" alt="Comfort Tech{{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema de resortes flexibles, que brinda una mejor adaptación al contorno del cuerpo.</li>
										<li>Provee un soporte óptimo para la columna vertebral, aumentando la sensación de confort durante el descanso.</li>
										<li>Gracias a la complexión del resorte, se eliminan los puntos de tensión y se aumenta la durabilidad del colchón.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/smart-fit-colchones-carreiro.png') }}" alt="Smart Fit {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Confort total.</li>
										<li>Sistema inteligente que alivia la presión acumulada.</li>
										<li>La espuma viscolástica se adapta 100% al cuerpo.</li>
										<li>Brinda a la espalda una correcta posición.</li>
										<li>Permite un sueño profundo y relajado.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/superior-foam-colchones-carreiro.png') }}" alt="Superior Foam {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Unidad de espumas de alta calidad que brindan una mayor firmeza en la columna vertebral.</li>
										<li>Fibras de poliuretano en diferentes densidades que permiten una alta recuperación y durabilidad en el colchón.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/soft-dream-colchones-carreiro.png') }}" alt="Soft Dream {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Fibras de poliuretano de alta recuperación.</li>
										<li>Posee mayor acojinamiento multicelular.</li>
										<li>Brinda mayor firmeza y comodidad.</li>
										<li>Capitonado especialmente diseñado para el descanso.</li>
									</ul>
								</div>
							</div>
						</div>
						<div>
							<div class="row align-items-center">
								<div class="col-12 col-md-6">
									<img src="{{ asset('img/sistemas/twist-colchones-carreiro.png') }}" alt="Twist {{ $titulo }}" class="d-block mx-auto img-fluid">
								</div>
								<div class="col-12 col-md-6">
									<ul class="azul raleway_bold">
										<li>Sistema con resortes y materiales de alta resistencia concentrados en sus dos caras.</li>
										<li>Colchón 100% duradero.</li>
										<li>Colchón de doble vuelta para mayor durabilidad.</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section> --}}

	{{-- <section>
		<script src="https://cdn.lightwidget.com/widgets/lightwidget.js"></script><iframe src="//lightwidget.com/widgets/b7785d40c9d55253a70935a8f69febaf.html" scrolling="no" allowtransparency="true" class="lightwidget-widget" style="width:100%;border:0;overflow:hidden;"></iframe>
	</section> --}}
	
	@include('includes.footer')
	<!-- Modal Temporal-->
	<div class="video-container">
		<div>
			<video controls {{ $agent->isMobile() ? 'muted' : '' }}>
				<source src="{{ asset('video/expo.webm') }}" type="video/webm">
				<source src="{{ asset('video/expo.mp4') }}" type="video/mp4">
				<source src="{{ asset('video/expo.ogg') }}" type="video/ogg">
			</video>
		</div>
		<i class="text-white fa-3x far fa-times-circle"></i>
	</div>
	{{-- <div class="modal fade" id="modal_temporal" tabindex="-1" role="dialog" aria-labelledby="modal_temporalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close" style="position: absolute;right: 0;top: -15px; font-size: 3rem; line-height: 3rem;">
						<span aria-hidden="true">&times;</span>
					</button>
					<a href="{{ route('hotelera') }}">
						<img src="{{ asset('img/modal/Invitacion_mueblera-2022.jpg') }}" alt="Colchones Carreiro" class="img-fluid mx-auto d-block">
					</a>
				</div>
			</div>
		</div>
	</div> --}}
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('popper/popper.min.js') }}"></script>
    <script src="{{ asset('bootstrap-4/js/bootstrap.min.js') }}?v=1"></script>
    {{-- Font Awesome --}}
    <script src="{{ asset('font-awesome-5.0.8/all.js') }}"></script>
    {{-- Num Scroller --}}
    <script src="{{ asset('numscroller/numscroller-1.0.js') }}"></script>
    {{-- AOS Scroll --}}
    <script src="{{ asset('aos-master/aos.js') }}"></script>
    {{-- SLICK Carousel --}}
    <script src="{{ asset('slick-1.8.0/slick.min.js') }}"></script>
    {{-- OWL CAROUSEL --}}
    <script src="{{ asset('owl-carousel/owl.carousel.min.js') }}"></script>

    {{-- JS --}}
    <script src="{{ asset('js/globales.js') }}"></script>
    <script src="{{ asset('js/index.js?v=1') }}"></script>

    <script src="{{ asset('js/modernizr.js') }}"></script>
    <script src="{{ asset('js/jquery.unleash.3.js') }}"></script>
    <script>
        $(document).ready(function() {

            $('body').on('click', '.fa-angle-up', function(event) {
            	event.preventDefault();
            	$(this).removeClass('fa-angle-up').addClass('fa-angle-down');
            	$(this).siblings('img').removeClass('d-block').fadeOut();
            	$(this).parents('.col').addClass('h100');
            	$(this).parents('.row').siblings('div').hide();
            	$(this).parent('div').addClass('flex-column justify-content-end');
            	$(this).siblings('div').slideDown();
            });

            $('body').on('click', '.fa-angle-down', function(event) {
            	event.preventDefault();
            	$(this).siblings('div').slideUp();
            	$(this).removeClass('fa-angle-down').addClass('fa-angle-up');
            	$(this).siblings('img').addClass('d-block').fadeIn();
            	$(this).parents('.col').removeClass('h100');
            	$(this).parents('.row').siblings('div').fadeIn();
            	$(this).parent('div').removeClass('flex-column justify-content-end');
            });
        });
    </script>
    <script>
    	var path = '{{ Request::root() }}';
    	// ocultar todo el body
    	var get = '{{ ( isset($_GET['m']) ? true : isset($_GET['contactanos']) ) ? true : false }}';

    	if (get) {
    		$(".unleash_slider").unleash({
    		    slide_width: "40%",
    		    duration: 700,
    		    slide_duration: 6000,
    		    slideshow: false,
    		    initially_open_slide: 0,
    		    hide_controls: true,
    		    pause_onmouseover: true,
    		    open_event: 'mouseover',
    		    collapse_on_mouseout: true
    		});
    	}
    	// mostar modal contacto
    	var contactanos = '{{ isset($_GET['contactanos']) }}';
    	$(document).ready(function(){

    		// $('#modal_temporal').modal('show')

    	    $('#index-video').on('ended',function(){

    	    	saltar_intro()
    	    	
    	    });

    	    // var audioElement = document.createElement('audio');
    	    // audioElement.setAttribute('src', '{{ asset('audio/Jingle.mp3') }}');
    	    // audioElement.volume = 0.1;

    	    // audioElement.addEventListener('ended', function() {
    	    // 	this.remove();
    	    // }, false);

    	    // $('#boton-con-manita').click(function(event) {
    	    // 	audioElement.play();
    	    	
    	    // });
    	});

    	function saltar_intro() {
    		$('body > section').show();

    		$(".unleash_slider").unleash({
    		    slide_width: "40%",
    		    duration: 700,
    		    slide_duration: 6000,
    		    slideshow: false,
    		    initially_open_slide: 0,
    		    hide_controls: true,
    		    pause_onmouseover: true,
    		    open_event: 'mouseover',
    		    collapse_on_mouseout: true
    		});

    		$('#index-video').parent('.index-video-wrapper').fadeOut('slow', function() {
    			$(this).remove();
    			$('#carousel').slick();
    		});
    		
    		// $('#boton-con-manita').fadeIn('slow');
    	}

    	$('.scroll').click(function(event) {
    		event.preventDefault();
    		console.log('scroll')
    		$('#menu_mobil').fadeOut();
    		var target = $(this).attr('href');
    		$('html, body').animate({
    			scrollTop: $(target).offset().top - 66
    		}, 800);
    	});
    </script>
</body>
</html>