<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	@php
		$titulo = $colchon[0] -> nombre." | Linea Hogar | Colchones Carreiro";
		$descripcion = "Colchones para toda la familia. Colchón individual, matrimonal, king size, colchones a excelente precio, contamos con colchones económicos y colchones elaborados con tecnología de vanguardia para asegurarte el mejor descanso a ti y a tu familia. Puedes checar nuestros modelos de colchones  en esta sección."
	@endphp
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('bootstrap-4/css/bootstrap.min.css') }}" >
    {{-- Slick --}}
    <link rel="stylesheet" href="{{ asset('slick-1.8.0/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('slick-1.8.0/slick-theme.css') }}">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>{{ $colchon[0] -> nombre }} | Línea Hogar Dreams Pack | Colchones Carreiro</title>
	<meta name="description" content="{{ $descripcion }}" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="{{ $colchon[0] -> nombre }} | Línea Hogar Dreams Pack | Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	{{-- <meta property="og:image" content="{{ asset('img/colchones/'.$colchon[0] -> imagen.'?v=1') }}" /> --}}
	<meta property="og:image" content="{{ asset('img/redes-sociales/'.$colchon[0]->slug.'.jpg') }}" />
	<meta property="og:description" content="{{ $descripcion }}" />
	
	
	
	<link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css') }}">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
		integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
		crossorigin="anonymous" referrerpolicy="no-referrer" />  
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/settings.css') }}">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/layers.css') }}">
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/navigation.css') }}">



	{{-- SLICK Carousel --}}
	<link rel="stylesheet" href="{{ asset('slick-1.8.0/slick.css') }}">
	{{-- CSS --}}
	<link rel="stylesheet" href="{{ asset('css/fuentes.css') }}">
	<link rel="stylesheet" href="{{ asset('css/globales.css?v=1') }}">
	<link rel="stylesheet" href="{{ asset('css/colchones.css') }}?v=1">

	<link rel="stylesheet" href="/css/main.css">

	<style>
		.sistema-principal {
			height: 90px !important;
		}
		.sistema-principal-largo {
			height: 50px !important;
		}
		.slick-slide {
  opacity: 0;
}
.slick-slide.slick-center, .slick-slide.slick-active {
  opacity: 1;
}
	</style>
	@if (!($fecha >= 7 && $fecha <= 18))
		<style>
			.fuente-blanco,
			.slick-prev:before, .slick-next:before {
				color: white !important;
			}
			@if ($agent->isMobile() || $agent->isTablet())
				#mobil {
					background-image: url({{ asset('img/fondos/fondo-cel-noche.jpg') }});
				}
			@endif
		</style>
	@endif
</head>
<body>
	<div id="loader" class="d-flex align-items-center justify-content-center">
		<div>
			<img src="{{ asset("img/logos/isologo-linea-$linea-colchones-carreiro.svg") }}" alt="{{ $titulo }}" class="img-fluid mx-auto d-block" width="200">
			<img src="{{ asset('img/loader.svg') }}" alt="{{ $titulo }}" class="img-fluid mx-auto d-block" width="100">
		</div>
	</div>
	@include('includes.header')
	@if ($agent->isMobile() || $agent->isTablet())
		<section id="mobil">
			<div class="container-fluid">
				<div class="row">
					<div class="col text-center">
						<h1 class="lato font-weight-bold azul mb-0 mt-1 fuente-blanco">
							{{ $colchon[0] -> nombre }}
						</h1>
						<div id="share"></div>
						<div>
							{{-- <img src="{{ asset('img/iconos/garantia-colchones-carreiro.svg') }}" alt="Garantia  Colchones Carreiro" width="100"> --}}
							<a href="{{ url('/tiendas') }}">
								<img src="{{ asset('img/iconos/donde-compro-mi-colchon.png') }}" alt="Donde Compro mi colchon" width="100" height="auto">
							</a>
							<img src="{{ asset('img/colchones/'.$colchon[0] -> imagen.'?v=5') }}" alt="{{ $colchon[0] -> nombre }}" class="img-fluid mx-auto d-block" data-toggle="modal" data-target="#modal-imagen-alta">
						</div>
						<div>
							<img src="{{ asset("img/logos/$logo_color") }}" alt="{{ $titulo }}" width="100" class="img-fluid mx-auto d-block mb-3">
							<a href="{{ url("/linea/hogar-dreams-pack/$anterior") }}">
								<img src="{{ asset("img/left$flecha_color") }}" alt="Colchones Carreiro" width="20" height="20">
							</a>
							<a href="{{ url("/linea/hogar-dreams-pack/$siguiente") }}">
								<img src="{{ asset("img/right$flecha_color") }}" alt="Colchones Carreiro" width="20" height="20">
							</a>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-10 mx-auto">

						@if (in_array($colchon[0]->id, [21,22,23,24,25]))
							@switch($colchon[0]->id)
								@case(25)
									<img src="{{ asset('img/Dreams Foam Pack.png') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" class="img-fluid mx-auto d-block">
									@break
								@case(24)
									<img src="{{ asset('img/sistemas_Dreams Multizone Pack.png') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" class="img-fluid mx-auto d-block">
									@break
								@default
									<img src="{{ asset('img/caja_sistemas_1.png') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" class="img-fluid mx-auto d-block">
							@endswitch
						@else
							<div class="row">
								<div class="col-12 fondo_azul bordes-superiores">
									<h4 class="raleway_regular blanco mb-0 py-2 h6 text-center">SISTEMAS DE DESCANSO</h4>
								</div>
							</div>
							<div class="row fondo_blanco">
								<div class="col-12 mx-auto py-2 @if ($tiene_secundarios) border-right @endif">
									<h5 class="raleway_regular mb-2 h6 text-center">Principal</h5>
									<img src="{{ asset('img/sistemas/iconos/'.$colchon[0] -> sistema_principal.'') }}" alt="" title="" class="img-fluid mx-auto d-block" style="max-height: 80px !important">
								</div>
								@if ($tiene_secundarios)
									<div class="col-12 mx-auto py-2">
										<h5 class="raleway_regular mb-2 h6 text-center">Secundarios</h5>
										<ul class="list-inline text-center">
											@if ($colchon[0] -> sistema_comfort_tech)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/comfort-tech-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_flame_proof)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/flame-proof-colchones-carreiro.png?v=1') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_high_resistance)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/high-resistance-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_multizone_technology)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/multizone-technology-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_smart_fit)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/smart-fit-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_soft_dreams)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/soft-dream-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_superior_foam)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/superior-foam-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_twist)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/twist-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_up_turn)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/up-turn-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_orthopedic)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/orthopedic-colchones-carreiro.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_free_vent)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/FreeVent.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
											@if ($colchon[0] -> sistema_rest_gel)
												<li class="list-inline-item">
													<img src="{{ asset('img/sistemas/iconos/Rest_Gel.png') }}" alt="" class="mx-auto img-fluid d-block" style="max-height: 70px !important">
												</li>
											@endif
										</ul>
									</div>
								@endif
							</div>
							<div class="row">
								<div class="col-12 fondo_azul">
									<h4 class="raleway_regular blanco mb-0 py-2 h6 text-center">CARACTERÍSTICAS</h4>
								</div>
							</div>
							<div class="row">
								<div class="col-12 fondo_blanco bordes-inferiores py-2">
									<p class="text-left raleway_regular"><small>
										@switch($colchon[0] -> id_principal)
											@case(6)
												Sistema Inteligente (Memory Foam), este material consigue que el cuerpo, al estar acostado, no tenga puntos en los que la presión sea muy alta (cabeza, hombros, cadera), sino que el material se amolde a todo el cuerpo y disipe la presión de manera uniforme.
												@break

											@case(7)
												Si buscas un descanso que se especialice en confort, que sea suave y además te ofrezca el soporte adecuado, este sistema de colchones Carreiro, es perfecto para ti. Ofrece un acojinamiento basado en espumas de alta calidad y resiliencia, garantizándote un descanso placentero y reparador.
												@break

											@case(4)
												Tecnología que ofrece gran confort, con un descanso libre de interrupciones durante la noche, gracias a sus resortes independientes (pocket spring) y materiales de la mejor calidad. Este sistema es el adecuado para ti que duermes acompañado con la sensación y el descanso absoluto de estar solo.
												@break

											@case(3)
												Tecnología Carreiro diseñada para el colchón clásico basada en resortes Bonell de gran firmeza, calidad y durabilidad para muchos años de descanso.
												@break

											@case(1)
												Colchón con tecnología Carreiro (Cosiflex) diseñada a base de un gran número de resortes para ofrecer gran confort, firmeza, calidad, durabilidad y un descanso libre de interrupciones gracias a su independencia entre resortes. 
												@break

											@case(8)
												Sistema de descanso con tecnología basada en un núcleo de espuma de poliuretano de alta calidad y densidad que ofrece confort, gran firmeza y durabilidad. 
												@break

											@case(10)
												Tecnología Carreiro, diseñada con materiales de alta calidad, concentrados en una sola cara para evitar la necesidad de rotarlo, ofreciendo un descanso confortable y sin vueltas. 
												@break
										
										@endswitch
										
									</small></p>
								</div>
							</div>
						@endif
					</div>
				</div>
			</div>
			@php
		$aux = $colchon[0] -> id;
	@endphp
	<section class="py-3" id="colchones_mini" @if ($agent->isMobile() || $agent->isTablet()) @else style="margin-top: -150px;"  @endif>
		<div class="container">
			<div class="row">
				<div class="col-sm-10 col-md-9 col-lg-8 col-xl-7 mx-auto">
					<div id="carousel_miniaturas" class="mt-4">
						@foreach ($colchones as $colchon)

							@continue($colchon->slug == 'viscolastic')
							@continue($colchon->slug == 'fluffy-collection')
							@continue($colchon->slug == 'gran-clase-imperial')
							@continue($colchon->slug == 'freedom')
							
							<div @if ($slug == $colchon -> slug) class="slick-active" @endif>
								<h6 class="raleway_bold text-center azul fuente-blanco"><small>{{ $colchon -> nombre }}</small></h6>
								<a href="{{ url('/linea/hogar-dreams-pack/'.$colchon -> slug.'') }}">
									<img src="{{ asset('img/colchones/miniaturas/'.$colchon -> imagen.'?v=6') }}" alt="{{ $colchon -> nombre }} Colchones Carreiro" class="mx-auto img-fluid d-block">
								</a>
							</div>
						@endforeach
					</div>
				</div>
			</div>
		</div>
	</section>
		</section>
	@else	
		<section class="example ajuste_menu" style="z-index: 11111;">
			<article class="content">
	           
		       <div id="rev_slider_1084_1_wrapper" class="rev_slider_wrapper fullscreen-container" data-alias="web-light-hero" data-source="gallery" style="margin:0px auto;padding:0px;margin-top:0px;margin-bottom:0px;background-image: url('{{ asset("img/fondos/$imagen_fondo") }}');background-position: center;background-repeat: no-repeat;background-size: cover;">
		           	<!-- START REVOLUTION SLIDER 5.4.1 fullwidth mode -->
		           	<div id="rev_slider_1084_1" class="rev_slider fullscreenbanner" style="display:none;" data-version="5.4.1">
		           		<ul>    <!-- SLIDE  -->
		           			<li data-index="rs-3074" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="1500"  data-rotate="0"  data-saveperformance="off"  data-title="Intro" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
		           				<!-- MAIN IMAGE -->
		           				<img src="{{ asset('img/fondos/nubes-colchones-carreiro-1.png') }}"  alt=""  data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="5" class="rev-slidebg" data-no-retina>
		           				<!-- LAYERS -->

		           				<!-- LAYER NR. 1 -->
		           				<div class="tp-caption tp-resizeme rs-parallaxlevel-6" 
		       						id="slide-3074-layer-1" 
		       						data-x="['right','right','center','center']" data-hoffset="['150','50','0','0']" 
		       						data-y="['middle']" data-voffset="['-20','-20','-370','-400']" 
		       						data-width="none"
		       						data-height="none"
		       						data-whitespace="nowrap"

		       						data-type="image" 
		       						data-responsive_offset="on" 

		       						data-frames='[{"from":"x:right;","speed":1500,"to":"o:1;","delay":2500,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
		       						data-textAlign="['left','left','left','left']"
		       						data-paddingtop="[0,0,0,0]"
		       						data-paddingright="[0,0,0,0]"
		       						data-paddingbottom="[0,0,0,0]"
		       						data-paddingleft="[0,0,0,0]"

		   							style="z-index: 5;text-transform:left;border-width:0px;" data-toggle="modal" data-target="#modal-imagen-alta">
									<img src="{{ asset('img/colchones/'.$colchon[0] -> imagen.'?v=5') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" data-ww="['600px','550px','400px','350px']" data-hh="['auto']" data-no-retina>
										<img src="{{ asset('img/iconos/ver-mas-colchones-carreiro.svg') }}" alt="" height="50" data-no-retina style="position: absolute; top: 50%; left: 0; margin-top: -100px; cursor: pointer">
									</div>

						        <!-- LAYER NR. 3 -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-5" 
						             id="slide-3074-layer-12" 
						             data-x="['left','left','left','left']" data-hoffset="['543','543','110','155']" 
						             data-y="['top','top','top','top']" data-voffset="['17','17','500','474']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;","delay":3950,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 1;text-transform:left;border-width:0px;">
									<div class="rs-looped rs-slideloop"  data-easing="Linear.easeNone" data-speed="30" data-xs="-600" data-xe="600" data-ys="0" data-ye="0"><img src="{{ asset('slider-revolution/assets/images/cloud1.png') }}" alt="" data-ww="['500px','500px','250','125px']" data-hh="['273px','273px','137','68px']" width="500" height="273" data-no-retina style="opacity: .8;"> </div></div>

						        <!-- LAYER NR. 6 -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-3" 
						             id="slide-3074-layer-13" 
						             data-x="['left','left','left','left']" data-hoffset="['294','294','116','97']" 
						             data-y="['top','top','top','top']" data-voffset="['400','400','745','641']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;","delay":3950,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 1;text-transform:left;border-width:0px;">
									<div class="rs-looped rs-slideloop"  data-easing="Linear.easeNone" data-speed="30" data-xs="-400" data-xe="400" data-ys="0" data-ye="0"><img src="{{ asset('slider-revolution/assets/images/cloud2.png') }}" alt="" data-ww="['600px','600px','300','150']" data-hh="['278px','278px','139','70']" width="600" height="278" data-no-retina style="opacity: .8;"> </div></div>

						        <!-- LAYER NR. 7 -->
						        {{-- <div class="tp-caption tp-resizeme rs-parallaxlevel-2" 
						            id="slide-3074-layer-5" 
						            data-x="['center']" data-hoffset="['-50','80','-230','-200']" 
						            data-y="['top','top','center','center']" data-voffset="['90','85','-480','-480']" 
						            data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						           data-frames='[{"from":"z:0;rX:0deg;rY:0;rZ:0;sX:1.5;sY:1.5;skX:0;skY:0;opacity:0;","mask":"x:0px;y:0px;s:inherit;e:inherit;","speed":1500,"to":"o:1;","delay":3750,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 11;text-transform:left;border-width:0px;"><img src="{{ asset('img/iconos/garantia-colchones-carreiro.svg') }}" alt="Garantia  Colchones Carreiro" data-ww="['100px']" data-hh="['auto']" data-no-retina> </div> --}}

					            <!-- LAYER NR. 8 copia -->
						        <div class="tp-caption tp-resizeme rs-parallaxlevel-2" 
						            id="slide-3074-layer-6-1" 
						            data-x="['left','left','center','center']" data-hoffset="['150','150','0','0']" 
						            data-y="['top','top','middle','middle']" data-voffset="['30','60','-170','-200']" 
						            data-width="['400','400','100%','100%']"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"delay":2000,"speed":2000,"frame":"0","from":"y:middle;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 12;text-transform:left;border-width:0px;"><img src="{{ asset("img/logos/$logo_color") }}" alt="Linea Hogar Colchones Carreiro" data-ww="['150px']" data-hh="['auto']" data-no-retina class="mx-auto d-block"> </div>

						        <!-- LAYER NR. 9 -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-1" 
						             id="slide-3074-layer-14" 
						             data-x="['left','left','left','left']" data-hoffset="['280','280','-10','-1']" 
						             data-y="['top','top','top','top']" data-voffset="['223','223','569','518']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;","delay":3950,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 1;text-transform:left;border-width:0px;">
									<div class="rs-looped rs-slideloop"  data-easing="Linear.easeNone" data-speed="30" data-xs="-200" data-xe="200" data-ys="0" data-ye="0"><img src="{{ asset('slider-revolution/assets/images/cloud3.png') }}" alt="" data-ww="['600px','600px','300','150']" data-hh="['278px','278px','181','90']" width="738" height="445" data-no-retina style="opacity: .8;"> </div></div>

						        <!-- LAYER NR. 10 -->
						        <div class="tp-caption WebProduct-Title tp-resizeme rs-parallaxlevel-7 lato azul fuente-blanco font-weight-bold" 
						            id="slide-3074-layer-7" 
						            data-x="['right','right','center','center']" data-hoffset="['150','50','0','0']" 
						            data-y="['top']" data-voffset="['10','10','30','30']" 
					             	data-fontsize="['40','40','40','40']"
						            data-lineheight="['90','90','75','60']"
						            data-width="['600','500','100%','100%']"
						            data-height="none"
						            data-whitespace="wrap"
						 
						            data-type="text" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1000,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 14; white-space: wrap;text-transform:left;">{{ $colchon[0] -> nombre }}
									</div>

						        <!-- LAYER NR. 11 -->
						        <div class="tp-caption WebProduct-Content tp-resizeme rs-parallaxlevel-7 raleway_italic azul fuente-blanco" 
						            id="slide-3074-layer-9" 
						            data-x="['right','right','center','center']" data-hoffset="['150','50','0','0']" 
						            data-y="['top']" data-voffset="['90','90','100','100']" 
					             	data-fontsize="['16','16','20','14']"
						            data-lineheight="['24','24','24','22']"
						            data-width="['600','500','100%','100%']"
						            data-height="['auto']"
						            data-whitespace="normal"
						 
						            data-type="text" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1500,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 15; min-width: 700px; max-width: 700px; white-space: normal;text-transform:left;">
									<div id="share"></div>
									</div>

					            <!-- LAYER NR. 11 copia -->
								@if (in_array($colchon[0]->id, [21,22,23,24,25]))
								<!-- LAYER SOLO CAJA -->
		           				<div class="tp-caption tp-resizeme rs-parallaxlevel-6" 
		       						id="slide-3074-layer-1" 
		       						data-x="['left','left','center','center']" data-hoffset="['150','50','0','0']" 
		       						data-y="['middle']" data-voffset="['-20','-20','-370','-400']" 
		       						data-width="none"
		       						data-height="none"
		       						data-whitespace="nowrap"

		       						data-type="image" 
		       						data-responsive_offset="on" 

		       						data-frames='[{"from":"x:right;","speed":1500,"to":"o:1;","delay":2500,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
		       						data-textAlign="['left','left','left','left']"
		       						data-paddingtop="[0,0,0,0]"
		       						data-paddingright="[0,0,0,0]"
		       						data-paddingbottom="[0,0,0,0]"
		       						data-paddingleft="[0,0,0,0]"

		   							style="z-index: 5;text-transform:left;border-width:0px;" data-toggle="modal" data-target="#modal-imagen-alta">
									@switch($colchon[0]->id)
										@case(25)
											<img src="{{ asset('img/Dreams Foam Pack.png') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" data-ww="['400','400px','400px','400px']" data-hh="['auto']" data-no-retina>
											@break
										@case(24)
											<img src="{{ asset('img/sistemas_Dreams Multizone Pack.png') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" data-ww="['400','400px','400px','400px']" data-hh="['auto']" data-no-retina>
											@break
										@default
											<img src="{{ asset('img/caja_sistemas_1.png') }}" alt="{{ $colchon[0] -> imagen }} Colchones Carreiro" data-ww="['400','400px','400px','400px']" data-hh="['auto']" data-no-retina>
									@endswitch
									</div>
								@else
									<div class="tp-caption tp-resizeme rs-parallaxlevel-7 raleway_italic azul" 
						            id="slide-3074-layer-9-1" 
						            data-x="['left','left','center','center']" data-hoffset="['150','150','0','0']" 
						            data-y="['middle','middle','middle','middle']" data-voffset="['20','20','-50','-80']" 
					             	data-fontsize="['18','25','300','300']"
						            data-lineheight="['25','25','100','100']"
						            data-width="['400','430','75%','95%']"
						            data-height="['none','none','81','88']"
						            data-whitespace="normal"
						 
						            data-type="image"
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1500,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 16; min-width: 400px; max-width: 400px; white-space: normal;text-transform:left;">
						            <div class="row">
						            	<div class="col-12 fondo_azul bordes-superiores">
						            		<img src="{{ asset('img/logos/angelita-colchones-carreiro.png') }}" alt="Colchone Carreiro" style="position: absolute;left: 10px;width: auto !important;height: 55px !important;" data-ww="['auto']" data-hh="['50px','50px','50px','50px']" id="angelita" style="height: 50px;width: auto;">
						            		<h4 class="raleway_regular blanco mb-0 py-2 h5">SISTEMAS DE DESCANSO</h4>
						            	</div>
						            </div>
						            <div class="row fondo_blanco">
						            	<div class="col-6 mx-auto py-2 @if ($tiene_secundarios) border-right @endif">
						            		<h5 class="raleway_regular mb-2">Principal</h5>
						            		<img src="{{ asset('img/sistemas/iconos/'.$colchon[0] -> sistema_principal.'') }}" alt="Colchones CArreiro" title="Colchones CArreiro" class="sistema-principal-largo">
						            	</div>
						            	@if ($tiene_secundarios)
						            		<div class="col-6 mx-auto py-2">
						            			<h5 class="raleway_regular mb-2">Secundarios</h5>
						            			<ul class="list-inline">
						            				@if ($colchon[0] -> sistema_comfort_tech)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/comfort-tech-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_flame_proof)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/flame-proof-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_high_resistance)
						            					@if ($colchon[0] -> nombre != "Línea Infantil")
						            						<li class="list-inline-item">
							            						<img src="{{ asset('img/sistemas/iconos/high-resistance-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
							            					</li>
						            					@endif
						            				@endif
						            				@if ($colchon[0] -> sistema_multizone_technology)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/multizone-technology-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_smart_fit)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/smart-fit-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_soft_dreams)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/soft-dream-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_superior_foam)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/superior-foam-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_twist)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/twist-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_up_turn)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/up-turn-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_orthopedic)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/orthopedic-colchones-carreiro.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_free_vent)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/FreeVent.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            				@if ($colchon[0] -> sistema_rest_gel)
						            					<li class="list-inline-item">
						            						<img src="{{ asset('img/sistemas/iconos/Rest_Gel.png') }}" alt="Colchones Carreiro" class="img_sistema">
						            					</li>
						            				@endif
						            			</ul>
						            		</div>
						            	@endif
						            </div>
						            <div class="row">
						            	<div class="col-12 fondo_azul">
						            		<h4 class="raleway_regular blanco mb-0 py-2 h5">CARACTERÍSTICAS</h4>
						            	</div>
						            </div>
						            <div class="row">
						            	<div class="col-12 fondo_blanco bordes-inferiores py-2">
						            		<h6 class="text-justify raleway_regular">
						            			@switch($colchon[0] -> id_principal)
						            				 @case(6)
						            			        Sistema Inteligente (Memory Foam), este material consigue que el cuerpo, al estar acostado, no tenga puntos en los que la presión sea muy alta (cabeza, hombros, cadera), sino que el material se amolde a todo el cuerpo y disipe la presión de manera uniforme.
						            			        @break

						            			    @case(7)
						            			        Si buscas un descanso que se especialice en confort, que sea suave y además te ofrezca el soporte adecuado, este sistema de colchones Carreiro, es perfecto para ti. Ofrece un acojinamiento basado en espumas de alta calidad y resiliencia, garantizándote un descanso placentero y reparador.
						            			        @break

					            			        @case(4)
					            			        	Tecnología que ofrece gran confort, con un descanso libre de interrupciones durante la noche, gracias a sus resortes independientes (pocket spring) y materiales de la mejor calidad. Este sistema es el adecuado para ti que duermes acompañado con la sensación y el descanso absoluto de estar solo.
					            			        	@break

				            			        	@case(3)
				            			        		Tecnología Carreiro diseñada para el colchón clásico basada en resortes Bonell de gran firmeza, calidad y durabilidad para muchos años de descanso.
					            			        	@break

				            			        	@case(1)
				            			        		Colchón con tecnología Carreiro (Cosiflex) diseñada a base de un gran número de resortes para ofrecer gran confort, firmeza, calidad, durabilidad y un descanso libre de interrupciones gracias a su independencia entre resortes. 
					            			        	@break

				            			        	@case(8)
				            			        		Sistema de descanso con tecnología basada en un núcleo de espuma de poliuretano de alta calidad y densidad que ofrece confort, gran firmeza y durabilidad. 
					            			        	@break

				            			        	@case(10)
				            			        		Tecnología Carreiro, diseñada con materiales de alta calidad, concentrados en una sola cara para evitar la necesidad de rotarlo, ofreciendo un descanso confortable y sin vueltas. 
					            			        	@break
						            			
						            			@endswitch
						            		</h6>
						            	</div>
						            </div>
						        </div>
								@endif

						        <!-- LAYER NR. 8 original -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-2" 
						            id="slide-3074-layer-6" 
						            data-x="['right','right','center','center']" data-hoffset="['70','50','200','150']" 
						            data-y="['bottom','bottom','center','center']" data-voffset="['180','170','-300','-350']" 
						            data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"delay":3750,"speed":1500,"frame":"0","from":"z:0;rX:0;rY:0;rZ:0;sX:0.8;sY:0.8;skX:0;skY:0;opacity:0;","to":"o:1;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            data-actions='[{
						            	"event": "click", 
						            	"action": "simplelink", 
						            	"target": "_self", 
						            	"url": "{{ url('/tiendas') }}"
						            }]'

						            style="z-index: 20;text-transform:left;border-width:0px;cursor: pointer;"><img src="{{ asset('img/iconos/donde-compro-mi-colchon.png') }}" alt="Donde Compro mi colchon" data-ww="['120x','120px','120px','120px']" data-hh="['auto']" data-no-retina style="width: 100px;height: auto;"> </div>

					            <div class="tp-caption tp-resizeme" 
 
								     data-frames='[{"delay": 500, "speed": 300, "from": "opacity: 0", "to": "opacity: 1"}, 
								                   {"delay": "wait", "speed": 300, "to": "opacity: 0"}]'

				                   	data-actions='[{
								        "event": "click", 
								        "action": "simplelink", 
								        "target": "_self", 
								        "url": "{{ url("/linea/hogar-dreams-pack/$siguiente") }}"
								 
								    }]' 
								 
								     data-type="image" 
								     data-x="right" 
								     data-y="center" 
								     data-hoffset="15" 
								     data-voffset="0" 
								     data-width="['auto']"
								     data-height="['auto']"
								 
								style="z-index: 50; cursor: pointer;"><img src="{{ asset("img/right$flecha_color") }}" alt="Colchones Carreiro" width="40" height="40" data-ww="['40px']" data-hh="['40px']"></div>

								 <div class="tp-caption tp-resizeme" 
 
								     data-frames='[{"delay": 500, "speed": 300, "from": "opacity: 0", "to": "opacity: 1"}, 
								                   {"delay": "wait", "speed": 300, "to": "opacity: 0"}]'

				                   	data-actions='[{
								        "event": "click", 
								        "action": "simplelink", 
								        "target": "_self", 
								        "url": "{{ url("/linea/hogar-dreams-pack/$anterior") }}"
								 
								    }]' 
								 
								     data-type="image" 
								     data-x="left" 
								     data-y="center" 
								     data-hoffset="15" 
								     data-voffset="0" 
								     data-width="['auto']"
								     data-height="['auto']"
								 
								style="z-index: 50; cursor: pointer;"><img src="{{ asset("img/left$flecha_color") }}" alt="Colchones Carreiro" width="40" height="40" data-ww="['40px']" data-hh="['40px']"></div>


						        <div class="tp-caption WebProduct-Content tp-resizeme rs-parallaxlevel-7 raleway_italic azul fuente-blanco" 
						            id="slide-3074-layer-23" 
						            data-x="['left','left','center','center']" data-hoffset="['150','150','0','0']" 
						            data-y="['middle','middle','middle','middle']" data-voffset="['-220','-220','-50','-80']" 
					             	data-fontsize="['16','20','300','300']"
						            data-lineheight="['20','20','100','100']"
						            data-width="['450','450','75%','95%']"
						            data-height="['none','none','81','88']"
						            data-whitespace="normal"
						 
						            data-type="text" 
						            data-responsive_offset="on" 
						 
						            data-type="text" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1500,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 23;">Elige el modelo que necesites, para que tu familia descanse de forma adecuada y que sueñen con los angelitos.</div>
						    </li>
						</ul>
						<div style="display: none !important;" class="tp-static-layers">

					        <!-- LAYER NR. 13 -->
					        <div class="tp-caption tp-static-layer" 
					            id="slider-1084-layer-1" 
					            data-x="['right','right','right','right']" data-hoffset="['30','30','30','30']" 
					            data-y="['top','top','top','top']" data-voffset="['30','30','30','30']" 
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text"
					            data-actions='[{"event":"click","action":"toggleclass","layer":"slider-1084-layer-1","delay":"0","classname":"open"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-3","delay":"0"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-4","delay":"0"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-5","delay":"0"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-6","delay":"0"}]'
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-startslide="-1" 
					            data-endslide="-1" 
					            data-frames='[{"from":"opacity:0;","speed":1000,"to":"o:1;","delay":500,"ease":"Power3.easeInOut"},{"delay":"wait","speed":1000,"to":"auto:auto;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 17; white-space: nowrap; font-size: 20px; line-height: 22px; font-weight: 400; color: rgba(255, 255, 255, 1.00);text-transform:left;border-width:0px;">XDDDDD
					            <div id="rev-burger">
					  				<span></span>
					  				<span></span>
					  				<span></span></div></div>
						</div>
						<div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div>
					</div>
				</div><!-- END REVOLUTION SLIDER -->
		
			</article>
		</section>
		<!-- Modal -->
	<div class="modal fade" id="modal-imagen-alta" tabindex="-1" role="dialog" aria-labelledby="modal-imagen-altaLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header d-none">
					<h5 class="modal-title" id="modal-imagen-altaLabel">Modal title</h5>
				</div>
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<img src="" alt="{{ $colchon[0] -> nombre }}" class="img-fluid mx-auto d-block lazy-load zoom-img" data-src-lazy="{{ asset('img/colchones/alta/'.$colchon[0] -> imagen.'?v=5') }}">
				</div>
				<div class="modal-footer d-none">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn btn-primary">Save changes</button>
				</div>
			</div>
		</div>
	</div>
	@php
		$aux = $colchon[0] -> id;
	@endphp
	<section class="py-3" id="colchones_mini" @if ($agent->isMobile() || $agent->isTablet()) style="background-image: url({{ asset('img/fondos/linea-hogar-colchones-carreiro.jpg') }});background-size: cover;background-repeat: no-repeat;background-position: center;background-attachment: fixed;" @else style="margin-top: -183px;"  @endif>
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-8 col-lg-10 col-xl-9 mx-auto">
					<div id="carousel_miniaturas" class="mt-4">
						@foreach ($colchones as $colchon)

							@continue($colchon->slug == 'viscolastic')
							@continue($colchon->slug == 'fluffy-collection')
							@continue($colchon->slug == 'gran-clase-imperial')
							@continue($colchon->slug == 'freedom')
							
							
							<div @if ($slug == $colchon -> slug) class="slick-active" @endif>
								<h6 class="raleway_bold text-center azul fuente-blanco"><small>{{ $colchon -> nombre }}</small></h6>
								<a href="{{ url('/linea/hogar-dreams-pack/'.$colchon -> slug.'') }}">
									<img src="{{ asset('img/colchones/miniaturas/'.$colchon -> imagen.'?v=6') }}" alt="{{ $colchon -> nombre }} Colchones Carreiro" class="mx-auto img-fluid d-block px-2">
								</a>
							</div>
						@endforeach
					</div>
				</div>
			</div>
		</div>
	</section>
	@endif
	@include('includes.footer')
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('popper/popper.min.js') }}"></script>
    <script src="{{ asset('bootstrap-4/js/bootstrap.min.js') }}"></script>


    
    {{-- Elevate ZOOM --}}
    <script src="{{ asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js') }}"></script>
    

    @if (!$agent->isMobile() || !$agent->isTablet())
	    <!-- REVOLUTION JS FILES -->
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/jquery.themepunch.tools.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/jquery.themepunch.revolution.min.js') }}"></script>

	    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->    
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.actions.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.carousel.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.kenburn.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.migration.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.navigation.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.parallax.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.slideanims.min.js') }}"></script>
	    <script type="text/javascript" src="{{ asset('slider-revolution/revolution/js/extensions/revolution.extension.video.min.js') }}"></script>
    @endif



	{{-- slick carousel --}}
	<script src="{{ asset('slick-1.8.0/slick.min.js') }}"></script>
    {{-- JS --}}
    <script src="{{ asset('js/globales.js') }}"></script>
    <script src="{{ asset('js/hogar-dreams-pack.js?v=1') }}"></script>
    {{-- pasar ID a JS --}}
    <script>
    	var id = {{ $aux }};
    	var path = '{{ Request::root() }}';

    	var tpj=jQuery;

		var revapi1084;
		tpj(document).ready(function() {
		    if(tpj("#rev_slider_1084_1").revolution == undefined){
		        revslider_showDoubleJqueryError("#rev_slider_1084_1");
		    }else{
		        revapi1084 = tpj("#rev_slider_1084_1").show().revolution({
		            sliderType:"hero",
		            jsFileLocation:"revolution/js/",
		            sliderLayout: 'fullscreen',
		            fullScreenOffsetContainer: "nav",
		            dottedOverlay:"none",
		            delay:9000,
		            navigation: {
		            },
		            responsiveLevels:[1240,1024,778,480],
		            visibilityLevels:[1240,1024,778,480],
		            gridwidth:[1400,1240,778,480],
		            gridheight:[680,690,1300,1300],
		            lazyType:"none",
		            @if (!($agent->isFirefox()))
		            parallax: {
		                type:"3D",
		                origo:"slidercenter",
		                speed:1000,
		                levels:[5,10,15,20,25,30,5,0,45,50,47,48,49,50,51,55],
		                type:"3D",
		                ddd_shadow:"off",
		                ddd_bgfreeze:"off",
		                ddd_overflow:"hidden",
		                ddd_layer_overflow:"visible",
		                ddd_z_correction:65,
		            },
		            @endif
		            spinner:'spinner3',
		            autoHeight:"off",
		            disableProgressBar:"on",
		            hideThumbsOnMobile:"off",
		            hideSliderAtLimit:0,
		            hideCaptionAtLimit:0,
		            hideAllCaptionAtLilmit:0,
		            debugMode:false,
		            fallbacks: {
		                simplifyAll:"off",
		                disableFocusListener:false,
		            }
		        });
		    }
		}); /*ready*/

    </script>


	<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery.jssocials/1.4.0/jssocials.min.js"></script>
	<link type="text/css" rel="stylesheet" href="https://cdn.jsdelivr.net/jquery.jssocials/1.4.0/jssocials.css" />
	<link type="text/css" rel="stylesheet" href="https://cdn.jsdelivr.net/jquery.jssocials/1.4.0/jssocials-theme-minima.css" />

	<script>
		$("#share").jsSocials({
				shares: ["facebook", "linkedin", "twitter", "pinterest", "email"],
				showLabel: false,
				showCount: false,
			});
	</script>

</body>
</html>