<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('bootstrap-4/css/bootstrap.min.css') }}" >
    {{-- Slick --}}
    <link rel="stylesheet" href="{{ asset('slick-1.8.0/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('slick-1.8.0/slick-theme.css') }}">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>@yield('titulo')</title>
	<meta name="description" content="@yield('descripcion')" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="@yield('titulo')" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	<meta property="og:image" content="{{ asset('img/doctora/redes-sociales-docotra-descanso-colchones-carreiro.jpg') }}" />
	<meta property="og:description" content="@yield('descripcion')" />
	
	<link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css') }}">
	<link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/fonts/font-awesome/css/font-awesome.css') }}">    
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/settings.css') }}">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/layers.css') }}">
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="{{ asset('slider-revolution/revolution/css/navigation.css') }}">

	{{-- CSS --}}
	<link rel="stylesheet" href="{{ asset('css/fuentes.css') }}">
	<link rel="stylesheet" href="{{ asset('css/globales.css?v=1') }}">
	<link rel="stylesheet" href="{{ asset('css/doctora.css') }}">
	@yield('css')
</head>
<body>
	@include('includes.header')
	<section id="doctora" class="ajuste_menu float-left">
		<div class="container-fluid">
			<div class="row">
				@yield('cabecera')
			</div>
		</div>
		<div class="container">
			@yield('contenido')
		</div>
	</section>
	<section id="twitter" class="float-left">
		<a class="twitter-timeline" href="https://twitter.com/DoctoraDescanso?ref_src=twsrc%5Etfw">Tweets by DoctoraDescanso</a> <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
	</section>
	<!-- Modal -->
	<div class="modal fade pr-0" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header d-none">
					<h5 class="modal-title" id="modalLabel">Modal title</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body rounded">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<p><strong>&iquest;Qui&eacute;n es la Doctora Descanso?</strong></p>
					<p>Estudi&eacute; la&nbsp;Licenciatura en Psicolog&iacute;a en la Universidad An&aacute;huac, y me especialic&eacute; en el &aacute;rea laboral. Tuve la oportunidad de realizar mis pr&aacute;cticas profesionales en el departamento de RRHH de la Bolsa Mexicana de Valores, para posteriormente trabajar en el mismo departamento en Colchones Carreiro. Al mismo tiempo inici&eacute; mis estudios en el Instituto Mexicano la Pareja (AMETEP), donde curs&eacute; la Maestr&iacute;a en Psicoterapia de Pareja e Individual.</p>
					<p>Durante mis estudios, comenc&eacute; a trabajar en un despacho psicopedag&oacute;gico en el cual, adem&aacute;s de psicoterapia, realic&eacute; valoraciones psicopedag&oacute;gicas a ni&ntilde;os y adolescentes, as&iacute; como valoraciones de orientaci&oacute;n vocacional. En el mismo despacho, fui Coordinadora de Valoraciones Psicopedag&oacute;gicas y Vocacionales.</p>
					<p>Fui docente, a nivel Licenciatura, en la Universidad Iberoamericana (IBERO) y en el Instituto Mexicano de la Pareja (AMETEP). Cuento con los cursos de Criminolog&iacute;a, Grafolog&iacute;a, Nutrici&oacute;n, Trastornos de la Personalidad,&nbsp; Sensibilizaci&oacute;n en Perspectivas de G&eacute;nero, Medicina del Sue&ntilde;o y Coaching, entre otros; as&iacute; como tambi&eacute;n con la Licenciatura en Psicolog&iacute;a homologada por la Uni&oacute;n Europea, siendo en Espa&ntilde;a donde tambi&eacute;n brind&eacute; orientaci&oacute;n y apoyo, evaluaci&oacute;n y/o terapia a ni&ntilde;os, adolescentes y adultos; aunado a haber impartido actividades de car&aacute;cter f&iacute;sico-cognitivo-social a adultos mayores.</p>
					<p align="center">"La vida es un camino a largo plazo, en la que tu eres maestro y alumno; unas veces te toca ense&ntilde;ar, todos los d&iacute;as te toca aprender"</p>
					<p>La marca Doctora Descanso, la cual represento, surgi&oacute; aproximadamente hace poco menos de tres a&ntilde;os, como iniciativa de Colchones Carreiro&reg;, para distinguir a la persona, totalmente capacitada y preparada, que se encargar&iacute;a de escribir y comunicar todo tipo cuestiones sobre salud, que afectan nuestro descanso y por supuesto, nuestra calidad de vida.</p>
					<p>Desde ese tiempo, comenc&eacute; a elaborar art&iacute;culos relevantes al sue&ntilde;o, cuestiones de salud y&nbsp; a la vez, me preocup&eacute; por publicar igualmente reflexiones que lleven a mis lectores y seguidores a mejorar su calidad de vida.</p>
					<p>A trav&eacute;s de mis redes sociales en Twitter, Facebook, desde hace poco Instagram, mi blog en&nbsp;<a href="http://colchonescarreiro.com/doctora-descanso-blog/" target="_blank" class="naranja">http://colchonescarreiro.com/doctora-descanso-blog/</a>, el programa de Radio 10 Tendencias con Pei Garza y el programa de radio "En los brazos de Morfeo" transmitido por Stereo Cien, busco llegar a m&aacute;s gente abordando temas de inter&eacute;s.</p>
					<p>La respuesta que he recibido y el seguimiento ha superado, tanto mis expectativas, como las de Colchones Carreiro&reg;, y por supuesto, ello nos motiva a mejorar y a seguir adelante y a seguir prepar&aacute;ndome d&iacute;a tras d&iacute;a.</p>
					<p>Actualmente contin&uacute;o prepar&aacute;ndome, y brindo asesor&iacute;a y orientaci&oacute;n psicol&oacute;gica presencial y a distancia.</p>
				</div>
				<div class="modal-footer d-none">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
				</div>
			</div>
		</div>
	</div>
	@include('includes.footer')
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('popper/popper.min.js') }}"></script>
    <script src="{{ asset('bootstrap-4/js/bootstrap.min.js') }}"></script>
    {{-- Font Awesome --}}
    {{-- <script src="{{ asset('font-awesome-5.0.8/all.js') }}"></script> --}}
    {{-- JS --}}
    <script src="{{ asset('js/globales.js') }}"></script>
    <script src="{{ asset('js/doctora.js') }}"></script>
    @yield('js')
    <script>var path = '{{ Request::root() }}';</script>
</body>
</html>