<?php

use Carreiro\Delegacion;
use Carreiro\Direccion;
use Carreiro\Estado;
use Illuminate\Database\Seeder;

class DireccionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        Schema::disableForeignKeyConstraints();

        Direccion::truncate();
        Delegacion::truncate();
        Estado::truncate();

Direccion::create([
    'tienda' => 'Muebles Azteca',
    'direccion' => 'Antonio Maceo # 38, Tacubaya, Miguel Hidalgo, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Miguel Hidalgo'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Almacenes San Martin',
    'direccion' => 'Lago Erne # 135, Pensil Norte, Miguel Hidalgo, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Miguel Hidalgo'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón Ticoman',
    'direccion' => 'Manizalez # 1007, Lindavista , Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Gustavo A. Madero'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón San Juan',
    'direccion' => 'Juan Francisco # 716, El Olivo , Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Gustavo A. Madero'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón',
    'direccion' => 'Calle 4 # 343, Pantitlan , Iztacalco , CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Iztacalco'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón Norte',
    'direccion' => 'Av. 551 # 139 , U.H. San Juan de Aragon 2da. Sección, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'N/D'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón Aragón',
    'direccion' => 'Oriente 142 # 162 , Moctezuma , Venustiano Carranza, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Venustiano Carranza'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón Norte',
    'direccion' => 'Oriente 142 # 162 , Moctezuma , Venustiano Carranza, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Venustiano Carranza'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surticolchón Euzkaro',
    'direccion' => 'Euzkaro # 162, Industrial , Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Gustavo A. Madero'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Almacenes San Martin',
    'direccion' => 'Municipio Libre # 825, Portales, Benito Juárez, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Benito Juárez'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Aroza y Compañía',
    'direccion' => 'Eje Central Lázaro Cárdenas #62, Cuauhtémoc, Obrera, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Cuauhtémoc'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La Casa Gris',
    'direccion' => 'Sara # 4405 Esq. Abel, Guadalupe Tepeyac, Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Gustavo A. Madero'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Santa Úrsula',
    'direccion' => '    San Ra&uacute;l Mz. 594 Lote 3, Santa Ursula Coapa, Coyoacán, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Coyoacán'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La Casa del Confort y el Descanso',
    'direccion' => 'Av. De los Maestros # 591 , Nueva Santa Maria, Azcapotzalco, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Azcapotzalco'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Lamas',
    'direccion' => 'Luis David # 3 Esq. Revolución, Mixcoac, Benito Juarez, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Benito Juarez'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La Casa del Confort y el Descanso',
    'direccion' => 'Av. Progreso Nacional # 237, Progreso Nacional , Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Gustavo A. Madero'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La Casa del Confort y el Descanso',
    'direccion' => 'Norte 9 # 4109, Panamericana, Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
            ['nombre' => 'Gustavo A. Madero'],
            ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Velia',
    'direccion' => 'Av. Texcoco # 166, Cuchilla del Tesoro , Gustavo A. Madero, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Gustavo A. Madero'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Azteca',
    'direccion' => 'Antonio Maceo # 38, Tacubaya, Miguel Hidalgo , CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Miguel Hidalgo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Oti Mueblerias',
    'direccion' => 'Mixtecas Manzana 92 Lote 27, Ajusco, Coyoacán, CDMX',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Coyoacán'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Ciudad de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'El Paraíso del Mueble',
    'direccion' => 'López Mateos s/n, Col. Colonos Centro Manzanillo Colima',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Colima'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Manzanillo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Colima'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'El Paraíso del Mueble',
    'direccion' => 'Av. Elias Zamora Verduzco 84 M 63 Valle de las Garzas Manzanillo Colima',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Colima'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Manzanillo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Colima'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles y Materiales Naucalpan',
    'direccion' => '    Gustavo Baz # 26 Centro  Naucalpan  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Naucalpan de Juárez'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Ok Muebles',
    'direccion' => 'Av. Cuauhtémoc s/n km. 28 Valle Verde Ixtapaluca Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Ixtapaluca'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Andrade',
    'direccion' => '    Av. Pantitlán # 626 La Perla  Nezahualcóyotl  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Nezahualcóyotl'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Andrade',
    'direccion' => 'Av. Solidaridad Mz. 2 Lte. 1 Covadonga Chalco  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chalco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Sanchez',
    'direccion' => '    Tierra y Libertad Mz. 1 Lote 7 Nueva San Antonio  Chalco  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chalco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Colchomex',
    'direccion' => 'Av. 1 de Mayo Mz. 4 Lte. 1 Santiago Tepalcapa Cuautitlán  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Cuautitlán'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'El Dormilón',
    'direccion' => '    Hidalgo # 18 Huitzilzingo  Chalco  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chalco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Miraflores',
    'direccion' => 'Av. Jose Antonio Álzate # 70 Centro  Ozumba de Alzate Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Ozumba'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Miraflores',
    'direccion' => 'Av. 16 de Septiembre # 17 Lote B San Rafael  Tlalmanalco  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tlalmanalco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Miraflores',
    'direccion' => 'Tomas Medina S/n San Francisco  Ixtapaluca Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Ixtapaluca'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Nuevo Crédito',
    'direccion' => 'Av. Cuauhtémoc # 7 Ayotla Ixtapaluca Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Ixtapaluca'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Guadalupe',
    'direccion' => '16 de Septiembre # 105 Centro  Cuautitlán  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Cuautitlán'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Virgen de Juquila',
    'direccion' => 'Av. Morelos # 205 Valle Dorado Naucalpan  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Naucalpan de Juárez'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Buen Hogar',
    'direccion' => 'Av. Hidalgo Esq. Progreso Acolco Teoloyucan  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Buen Hogar',
    'direccion' => 'Av. Hidalgo # 29 Centro Tlalnepantla  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tlalnepantla de Baz'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles San Leo',
    'direccion' => 'Av. Perla Mz. 22 Lote 29 Ampliación Buenavista Tultitlán  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tultitlán'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Lechería',
    'direccion' => 'Av. 11 de Julio # 57 Lechería Tultitlán  Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tultitlán'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Locos de Remate',
    'direccion' => 'Pasaje 16 # 112-B Santa Clara Toluca Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Toluca'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'General de Muebles',
    'direccion' => 'Alfredo del Mazo OTE. # 52 Morelos Atlacomulco Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atlacomulco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería 2000',
    'direccion' => 'Av. José Ma. Morelos # 210 Altos Tianguistenco de Galeana Tianguistenco Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tianguistenco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Benítez',
    'direccion' => 'Av. Independencia # 110 Centro Mexicaltzingo Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Mexicaltzingo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Colchones y  ALgo más',
    'direccion' => 'Av. del Peñon Mz. 1 Lote 3-4 Acuitlapilco Chimalhuacan Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chimalhuacan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Almacenes las fuentes',
    'direccion' => 'Carretera México Texcoco km. 29 San José San Vicente Chicoloapan Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chicoloapan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Almacenes las fuentes',
    'direccion' => 'Cantu # 85 San Martin Azcatepec Tecamac Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tecamac'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Almacenes Perez José Jimenex',
    'direccion' => 'Cantu # 85 San Martin Azcatepec Tecamac Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tecamac'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueble México',
    'direccion' => 'Av. pajaros # 43 Granjas Guadalupe Nicolas Romero Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Nicolas Romero'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Emobel',
    'direccion' => 'Av. Via Real Mz. 16, Lote 1 Local 1 Fracc. Real del Sol Tecamac Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tecamac'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'emo',
    'direccion' => 'Av. Primavera S/n Fracc. Real Solare El Marques Estado de México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Tianguis Mueblero',
    'direccion' => 'Av. Zaragoza # 301 Esq. Guerrero Centro  Salamanca Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Salamanca'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Núñez',
    'direccion' => 'Benjamín Mendez Aguilera # 14 Centro Jerécuaro  Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Jerécuaro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Núñez',
    'direccion' => 'Manuel Doblado # 37 Centro Jerécuaro  Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Jerécuaro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surti Hogar',
    'direccion' => '5 de Mayo # 203 Centro  Apaseo el Alto Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Apaseo el Alto'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Surti Hogar',
    'direccion' => 'Guerrero #521 Centro Irapuato Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Irapuato'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mosqueta',
    'direccion' => 'Carr. San Miguel Dr. Mora Km 2.5 Hacienda de Landeta San Miguel de Allende Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'San Miguel de Allende'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebleria Estrella',
    'direccion' => 'Miguel Hidalgo #408 Centro Jaral de Progreso Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Jaral del Progreso'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebleria Estrella',
    'direccion' => 'Benito Juarez #526 Centro Jaral de Progreso Guanajuato',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Jaral del Progreso'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Guanajuato'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Distribuidora Hidalgo',
    'direccion' => 'Morelos Esq. Calle 7 Centro    Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tezontepec de Aldama'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Modelo',
    'direccion' => 'Hidalgo Oriente # 312 Centro  Tulancingo  Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tulancingo de Bravo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Dos Perlas',
    'direccion' => 'Av. Juan Aldama S/n Centro Tezontepec de Aldama  Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tezontepec de Aldama'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblihogar',
    'direccion' => 'Av. Allende # 24 Centro Tezontepec de Aldama  Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tezontepec de Aldama'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Comercial Mueblera Tepeji',
    'direccion' => 'Melchor Ocampo # 31 Noxtongo Tepeji del Rio Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tepeji del Río de Ocampo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería los Arcos',
    'direccion' => 'Carretera federal México Laredo km. 119 # 139 Benito Juárez Actopan Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Actopan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Emobel',
    'direccion' => 'Carretera Jorobas Tula km. 12 Lote 14 Fracc. Real de Castilla Atotonilco de Tula Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atotonilco de Tula'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Emobel',
    'direccion' => 'Carretera México-Pachuca km. 7935 Fracc. Real Toledo San Antonio el Desmonte Hidalgo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Hidalgo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería las Colonias',
    'direccion' => 'Mayas # 5 Las Colonias Tepatitlán  Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Tepatitlán de Morelos'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería las Colonias',
    'direccion' => 'Hidalgo # 119 Centro Acatic Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Acatic'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Casa Ruiz de Ciudad Guzmán',
    'direccion' => 'Cristóbal Colon 232 Centro Zapotlan Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Zapotlán el Grande'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblera la Campana',
    'direccion' => 'Calle Hidalgo 202, Centro, 47200 Teocaltiche, Jal.',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Teocaltiche'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Casa Ruiz de Ciudad Guzman',
    'direccion' => 'Federico del Toro # 170 Centro Ciudad Guzman Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Casa Ruiz de Ciudad Guzman',
    'direccion' => 'Federico del Toro # 170 Centro Ciudad Guzman Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'TAO Muebles y Decoraciones',
    'direccion' => 'Francisco I. Madero #699 Int. 1 Centro Chapala Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chapala'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La más Barata',
    'direccion' => 'Fagoaga # 72 A Centro Puruandiro  Michoacán',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Puruándiro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La más Barata',
    'direccion' => 'Manuel Doblado # 47 Centro  Puruandiro  Michoacán',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Puruándiro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La más Barata',
    'direccion' => 'Guerrero # 117 Centro  Puruandiro  Michoacán',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Puruándiro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Luxory Muebles',
    'direccion' => 'Calz. La Fuente # 2190 El Colorín  Puruandiro  Michoacán',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Puruándiro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles Hogar',
    'direccion' => 'Av. Fuentes de Morelia #390 Fuentes de Morelia Morelia Michoacán',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Morelia'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Michoacán de Ocampo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería la Poblana',
    'direccion' => 'Francisco I. Madero # 177-2 Emiliano Zapata Cuautla  Morelos',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Morelos'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Cuautla'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Morelos'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería la Poblana',
    'direccion' => 'Av. Insurgentes # 151 Emiliano Zapata Cuautla  Morelos',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Morelos'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Cuautla'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Morelos'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Marcen',
    'direccion' => 'Clavel # 12 El Eden  Jiutepec Morelos',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Morelos'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Jiutepec'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Morelos'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Bodega de Muebles',
    'direccion' => '15 Norte # 103 Centro Atlixco Puebla',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atlixco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Terminal',
    'direccion' => 'Independencia # 516 Centro Atlixco Puebla',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atlixco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Rande Comercial',
    'direccion' => '3 Sur Centro Atlixco Puebla',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atlixco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Rande Comercial',
    'direccion' => '5 Poniente Centro Atlixco Puebla',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atlixco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Hogarama Mueblerías',
    'direccion' => '3 Norte # 202-D Centro San Pedro Cholula Puebla',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'San Pedro Cholula'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Puebla'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Centro Mueblero Querétaro',
    'direccion' => 'Corregidora Norte # 152-B Centro Querétaro Querétaro',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Querétaro'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Querétaro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Querétaro'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Centro Mueblero Querétaro',
    'direccion' => 'Corregidora Norte # 152-B Centro Querétaro Querétaro',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Querétaro'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Querétaro'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Querétaro'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Emobel',
    'direccion' => 'Av. 58 Nte. Mz. 6 Lote 4 Local 7-G Fracc. Real Ibiza Playa del Carmen Quintana Roo',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Quintana Roo'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Real Ibiza'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Quintana Roo'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'América Muebles',
    'direccion' => 'Iturbide Oriente # 18 Centro  Santa Ana Chiautempan  Tlaxcala',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Tlaxcala'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Chiautempan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Tlaxcala'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Muebles y Decoraciones el Naranjo',
    'direccion' => 'Hidalgo # 46 Centro  Río Grande  Zacatecas',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Zacatecas'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Río Grande'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Zacatecas'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Divisa Muebles',
    'direccion' => 'morelos #60 Centro Sain Alto. Zacatecas',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Zacatecas'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Sain Alto'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Zacatecas'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'La Bodeguita Almacen y Saldos',
    'direccion' => 'Av. 3er Anillo Periferico #120 Col. El Angel Delegación Villa de Alvarez, Colima Colima',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Colima'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Colima'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Colima'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Jerico',
    'direccion' => 'Vallarta 335 47930 Ayotlán, Jal.',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Ayotlán'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Jerico',
    'direccion' => 'Emiliano Zapata 31 Colonia Centro San Sebastian el Grande Guadalajara Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Guadalajara'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Vero',
    'direccion' => 'Avenida Tejiscan 1185 Colonia San Francisco Zapopan Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Zapopan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Vero',
    'direccion' => 'Santa Esther 398 Santa Margarita Zapopan Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Zapopan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Vero',
    'direccion' => 'Av. Lirios 1440 Col. Prodos de Santa Lucía',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'N/D'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'N/D'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Vero',
    'direccion' => 'Avenida Copalita 24 Col. Vicente Guerrero',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'N/D'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'N/D'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Vero',
    'direccion' => 'Primera Poniente 464 Colonia Jardines de Nuevo México',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'N/D'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'N/D'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'N/D'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Mariela',
    'direccion' => 'Av. Lpez Mateos 96B Col. Centro San Ignacio Cerro Gordo Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'San Ignacio Cerro Gordo'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Mueblería Vero',
    'direccion' => 'Carretera a tejiscan 4213 Col. Nuevo México Zapopan, Jalisco',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Zapopan'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Jalisco'])->id]
    )->id
]);
Direccion::create([
    'tienda' => 'Comercial Mueblería Garduño',
    'direccion' => 'Alfredo del Mazo Pte. 57 Atlacomulco De Fabela CP 50450 Atlacomulco, Méx.',
    'estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id,
    'delegacion_id' => Delegacion::firstOrCreate(
        ['nombre' => 'Atlacomulco'],
        ['estado_id' => Estado::firstOrCreate(['nombre' => 'Estado de México'])->id]
    )->id
]);

    Schema::enableForeignKeyConstraints();

    }
}
