<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CrearTablaColchones extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('colchones', function (Blueprint $table) {
            $table->increments('id');
            $table->string('nombre');
            $table->unsignedInteger('linea');
            $table->foreign('linea')->references('id')->on('lineas');
            $table->string('frase');
            $table->string('imagen');
            $table->text('caracteristicas');
            $table->unsignedInteger('sistema_principal');
            $table->foreign('sistema_principal')->references('id')->on('sistemas');
            $table->boolean('sistema_comfort_tech')->default(0);
            $table->boolean('sistema_flame_proof')->default(0);
            $table->boolean('sistema_high_resistance')->default(0);
            $table->boolean('sistema_multizone_technology')->default(0);
            $table->boolean('sistema_orthopedic')->default(0);
            $table->boolean('sistema_smart_fit')->default(0);
            $table->boolean('sistema_soft_dreams')->default(0);
            $table->boolean('sistema_superior_foam')->default(0);
            $table->boolean('sistema_twist')->default(0);
            $table->boolean('sistema_up_turn')->default(0);
            $table->string('slug');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('colchones');
    }
}
