<?php

namespace Carreiro\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Jenssegers\Agent\Agent;
use Illuminate\Support\Facades\DB;

class SeleccionarColchonesHogar extends Controller
{
    //
    public function __invoke($slug){
    	$colchon = DB::table('colchones')
    				->join('sistemas', 'colchones.sistema_principal', '=', 'sistemas.id')
    				->select('colchones.*', 'sistemas.imagen as sistema_principal' ,'sistemas.id as id_principal')
    				->where('slug', '=', $slug)
    				->get();

		$colchones = DB::table('colchones')        
    				->select('slug','imagen','nombre')
    				->where('linea', 1)
                    ->where('id', '<', 18)
    				->get();

        $siguiente = DB::table('colchones')
                    ->select('slug')
                    ->where('id', '>', $colchon[0] -> id)
                    ->where('id', '<', 18)
                    ->limit(1)
                    ->value('slug');

        $anterior = DB::table('colchones')
                    ->select('slug')
                    ->where('id', '<', $colchon[0] -> id)
                    ->where('id', '<', 18)
                    ->limit(1)
                    ->value('slug');

        if ($siguiente == null) {
            $siguiente = DB::table('colchones')
                    ->select('slug')
                    ->orderBy('id', 'asc')
                    ->where('id', '<', 18)
                    ->limit(1)
                    ->value('slug');
        }

        if ($anterior == null) {
            $anterior = DB::table('colchones')
                    ->select('slug')
                    ->orderBy('id', 'desc')
                    ->where('id', '<', 18)
                    ->limit(1)
                    ->value('slug');
        }

        if (($colchon[0] -> sistema_comfort_tech == 1) || ($colchon[0] -> sistema_flame_proof == 1) || ($colchon[0] -> sistema_high_resistance == 1) || ($colchon[0] -> sistema_multizone_technology == 1) || ($colchon[0] -> sistema_orthopedic == 1) || ($colchon[0] -> sistema_smart_fit == 1) || ($colchon[0] -> sistema_soft_dreams == 1) || ($colchon[0] -> sistema_superior_foam == 1) || ($colchon[0] -> sistema_twist == 1) || ($colchon[0] -> sistema_up_turn == 1) || ($colchon[0] -> sistema_free_vent == 1) || ($colchon[0] -> sistema_rest_gel == 1)) {
            $tiene_secundarios = true;
        } else {
            $tiene_secundarios = false;
        }

        $fecha = Carbon::now()->format('H');
        if (($fecha >= 7) && ($fecha <= 18)) {
            $imagen_fondo = 'linea-hogar-colchones-carreiro-dia.jpg';
            $logo_color = 'isologo-linea-hogar-colchones-carreiro.svg';
            $flecha_color = '.png';
        } else {
            $imagen_fondo = 'linea-hogar-colchones-carreiro-noche.jpg?v=1';
            $logo_color = 'isologo-linea-hogar-colchones-carreiro-blanco.svg';
            $flecha_color = '-blanco.png';
        }

        $agent = new Agent();

        //Colchones Cajas
        switch ($colchon[0]->id) {
            case 18:
                $colchon[0]->sistema_principal = 'sistemas_azul.png';
                break;
            case 19:
                $colchon[0]->sistema_principal = 'sistemas_naranja.png?v=2';
                break;
            case 20:
                $colchon[0]->sistema_principal = 'sistemas_verde.png?v=1';
                break;
            
            default:
                # code...
                break;
        }

    	return view('hogar')->with([
    		'colchon' => $colchon,
    		'colchones' => $colchones,
            'slug' => $slug,
            'tiene_secundarios' => $tiene_secundarios,
            'linea' => 'hogar',
            'siguiente' => $siguiente,
            'anterior' => $anterior,
            'imagen_fondo' => $imagen_fondo,
            'fecha' => $fecha,
            'logo_color' => $logo_color,
            'flecha_color' => $flecha_color,
            'agent' => $agent
    	]);
    }
}